/**
 * Changed Code - Different from original on GitHub
 */

/**
 * Source: https://github.com/dozyatom/guide.js Commit 8cb5b24
 * - Patched by iMi to use German Language
 * - Default no Margin (0) because it does not make sense for elements at the window border
 */
(function ($) {

    var guide = function () {
        var container,
            defaults = {
                margin: 0
            },
            topMask = $("<div/>").addClass("guideMask"),
            bottomMask = $("<div/>").addClass("guideMask"),
            leftMask = $("<div/>").addClass("guideMask"),
            rightMask = $("<div/>").addClass("guideMask"),
            bubble = $("<div/>").addClass("guideBubble"),
            holdingSteps,
            steps,
            position,

            prevButton = $("<button/>").addClass("btn").html("Zurück"),
            nextButton = $("<button/>").addClass("btn").html("Weiter"),
            arrow = $("<div/>").addClass("guideBubble-arrow").addClass("top"),

            gotoStep = function (i) {
                positionMask(i);
                positionBubble(i);
            },
            nextStep = function () {
                position++;
                if (position >= steps.length) {
                    clearGuide();
                } else {
                    gotoStep(position);
                }
            },
            prevStep = function () {
                position--;
                if (position < 0) {
                    position = steps.length - 1;
                }
                gotoStep(position);
            },
            getElementAttrs = function (element, isFixed) {

                if (isFixed){
                    return {
                        top: element.position().top,
                        left: element.offset().left ,
                        width: element.outerWidth(),
                        height: element.outerHeight()
                    }
                }

                return {
                    top: element.offset().top,
                    left: element.offset().left ,
                    width: element.outerWidth(),
                    height: element.outerHeight()
                }
            },
            positionMask = function (i) {
                var element = steps[i].element;

                var checkElements = element.add(element.parents());
                var isFixed = false;
                checkElements.each(function(){
                    if ($(this).css("position") === "fixed") {
                        isFixed = true;
                    }
                });

                var margin = (steps[i].options && steps[i].options.margin) ? steps[i].options.margin : options.margin,
                    attrs = getElementAttrs(element, isFixed),
                    top = attrs.top,
                    left = attrs.left,
                    width = attrs.width,
                    height = attrs.height;

                topMask.css({
                    height: (top - margin) + "px"
                });

                bottomMask.css({
                    top: (height + top + margin) + "px",
                    height: ($(document).height() - height - top - margin) + "px"
                });

                leftMask.css({
                    width: (left - margin) + "px",
                    top: (top - margin) + "px",
                    height: (height + margin * 2) + "px"
                });

                rightMask.css({
                    left: (left + width + margin) + "px",
                    top: (top - margin) + "px",
                    height: (height + margin * 2) + "px",
                    width: ($(document).width() - width - left - margin) + "px",
                });


                if (isFixed){
                    topMask.add(bottomMask).add(leftMask).add(rightMask).css('position', 'fixed');
                } else {
                    topMask.add(bottomMask).add(leftMask).add(rightMask).css('position', 'absolute');
                }

            },
            positionBubble = function (i) {
                var element = steps[i].element,
                    margin = (steps[i].options && steps[i].options.margin) ? steps[i].options.margin : options.margin,
                    top = element.offset().top,
                    left = element.offset().left,
                    width = element.outerWidth(),
                    height = element.outerHeight();

                var css = {
                    top: (height + top + margin + 10) + "px"
                };

                if ((left + bubble.outerWidth()) > $(document).width()) {
                    $(".guideBubble-arrow", bubble).css({"right": "10px"});
                    css.left = left + element.outerWidth() - bubble.outerWidth() + margin;
                } else {
                    $(".guideBubble-arrow", bubble).css({"right": "auto"});

                    css.left = left - margin;
                }

                bubble.animate(css, 500, function () {
                    scrollIntoView();
                    if (steps[i].options.callback) {
                        steps[i].options.callback();
                    }
                });

                $(".step", bubble).html(i + 1);
                $(".intro", bubble).html(steps[i].intro);
                prevButton.removeClass("disabled");
                nextButton.removeClass("disabled");

                if (!position) {
                    prevButton.addClass("disabled");
                }

                if (position == (steps.length - 1)) {
                    nextButton.html("Schließen").addClass("btn-danger");
                } else {
                    nextButton.html("Weiter").removeClass("btn-danger");
                }


                scrollIntoView();
            },
            scrollIntoView = function () {
                var element = steps[position].element;

                if (($(document).scrollTop() > element.offset().top) || (($(document).scrollTop() + $("body").height()) < element.offset().top)) {
                    $('html, body').animate({
                        scrollTop: element.offset().top - 20
                    });
                }
            },
            clearGuide = function () {
                bubble.detach();
                topMask.add(bottomMask).add(leftMask).add(rightMask).animate({
                    opacity: 0
                }, 500, function () {
                    topMask.add(bottomMask).add(leftMask).add(rightMask).detach();
                })

            },
            getMaximumZIndex = function () {
                var max = 0;
                $("*").each(function () {
                    var current = parseInt($(this).css("zIndex"), 10);
                    if (current > max) {
                        max = current;
                    }
                });
                return max;
            }


        return {
            init: function (opts) {
                container = $(this);
                options = $.extend({}, defaults, opts);
                steps = [];
                holdingSteps = [];
                position = -1;
                zIndex = getMaximumZIndex();

                topMask.add(bottomMask).add(leftMask).add(rightMask).css("z-index", zIndex + 1);
                bubble.css("z-index", zIndex + 2).html("").append(arrow).append($("<div/>").addClass("step").html("1")).append($("<div/>").addClass("intro")).append($("<div/>").addClass("btn-group pull-right").append(prevButton).append(nextButton));

                prevButton.on("click", function () {
                    if (!$(this).hasClass("disabled")) {
                        prevStep();
                    }
                });
                nextButton.on("click", function () {
                    if (!$(this).hasClass("disabled")) {
                        nextStep();
                    }
                });

                topMask.add(bottomMask).add(leftMask).add(rightMask).on("click", function () {
                    clearGuide();
                });

                return {
                    addStep: function (selector, introduction, options) {
                        holdingSteps.push({
                            selector: selector,
                            intro: introduction,
                            options: options || {}
                        });
                    },
                    start: function () {
                        container.append(topMask, bottomMask, leftMask, rightMask);
                        container.append(bubble);
                        topMask.add(bottomMask).add(leftMask).add(rightMask).animate({
                            opacity: 0.5
                        }, 500);
                        position = -1;
                        steps = [];
                        $.each(holdingSteps, function (i, step) {
                            if ($(step.selector).length) {
                                var attrs = getElementAttrs($(step.selector));
                                if (attrs.width != 0 && attrs.height != 0) {
                                    steps.push({
                                        element: $(step.selector),
                                        selector: step.selector,
                                        intro: step.intro,
                                        options: step.options
                                    });
                                }
                            }
                        });
                        nextStep();
                    }
                }
            },

        }
    }();

    $.fn.extend({
        guide: guide.init
    });
}(jQuery));