!function(window){
    var $q = function(q, res){
            if (document.querySelectorAll) {
                res = document.querySelectorAll(q);
            } else {
                var d=document
                    , a=d.styleSheets[0] || d.createStyleSheet();
                a.addRule(q,'f:b');
                for(var l=d.all,b=0,c=[],f=l.length;b<f;b++)
                    l[b].currentStyle.f && c.push(l[b]);

                a.removeRule(0);
                res = c;
            }
            return res;
        }
        , addEventListener = function(evt, fn){
            window.addEventListener
                ? this.addEventListener(evt, fn, false)
                : (window.attachEvent)
                ? this.attachEvent('on' + evt, fn)
                : this['on' + evt] = fn;
        }
        , _has = function(obj, key) {
            return Object.prototype.hasOwnProperty.call(obj, key);
        }
    ;

    function loadImage (el, fn) {
        if (el.classList.contains('lazyloaded')) {
            return;
        }
        var img = new Image()
            , src = el.getAttribute('data-src');
        if ('undefined' === typeof src || null === src) {
            return;
        }
        img.onload = function() {
            if (!! el.parent) {
                el.parent.replaceChild(img, el);
                el.parent.classList.add('lazyloaded');
            } else {
                el.style.backgroundImage = 'url(' + src + ')';
                el.classList.add('lazyloaded');
            }

            try {
                el.dispatchEvent(new CustomEvent('lazyloaded'));
            } catch (e) {
                //
            }

            fn? fn() : null;
        }
        img.src = src;
    }

    function elementInViewport(el) {
        var rect = el.getBoundingClientRect()

        return (
            rect.top    >= 0
            && rect.left   >= 0
            && rect.top <= (window.innerHeight || document.documentElement.clientHeight)
        )
    }

    var images = new Array()
        , query = $q('.lazyload')
        , processScroll = function(){
            for (var i = 0; i < images.length; i++) {
                if (elementInViewport(images[i])) {
                    loadImage(images[i], function () {
                        images.splice(i, i);
                    });
                }
            };
        }
    ;

    for (var i = 0; i < query.length; i++) {
        images.push(query[i]);
    };

    processScroll();
    addEventListener('scroll', processScroll);

}(this);

var _validateEmail = function (email) {
    var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return re.test(String(email).toLowerCase());
};

var _processAPIError = function (data) {
    var text = [];
    var bag = data.error || data;
    if ('object' === typeof bag) {
        for (i in bag) {
            text.push(bag[i]);
        }
    } else if ('undefined' !== typeof bag) {
        text.push(bag);
    } else {
        text.push(data);
    }
    return text;
};

var isTouchDevice = function() {
    var prefixes = ' -webkit- -moz- -o- -ms- '.split(' ');
    var mq = function(query) {
        return window.matchMedia(query).matches;
    };
    if ( ('ontouchstart' in window) || window.DocumentTouch && document instanceof DocumentTouch ) {
        return true;
    }
    var query = ['(', prefixes.join('touch-enabled),('), 'heartz', ')'].join('');
    return mq(query);
};

$.fn.isInViewport = function() {
    var elementTop = $(this).offset().top;
    var elementBottom = elementTop + $(this).outerHeight();
    var viewportTop = $(window).scrollTop();
    var viewportBottom = viewportTop + $(window).height();
    return elementBottom > viewportTop && elementTop < viewportBottom;
};

$.fn.isInViewportFully = function() {
    var elementTop = $(this).offset().top;
    var elementBottom = elementTop + $(this).outerHeight();
    var viewportTop = $(window).scrollTop();
    var viewportBottom = viewportTop + $(window).height();
    return elementTop >= viewportTop && elementBottom <= viewportBottom;
};

$(document).ready(function () {
    var didScroll;
    var lastScrollTop = 0;
    var delta = 5;
    var navbarHeight = $('header').outerHeight();
    var clipboard = new ClipboardJS('.clipboard');
    var oldCityFieldStr = '';
    var oldSearchStr = '';
    var searchRequest = null;
    var searchResultsCache = [];
    var searchResultCurrent = -1;
    var geoResultsCache = [];
    var geoResultCurrent = -1;
    var geoRequest = null;

    $('.selectpicker').selectpicker();

    clipboard.on('success', function(e) {
        e.clearSelection();

        swal({
            type: 'success',
            title: 'Erfolgreich kopiert',
            toast: true,
            position: 'bottom-end',
            showConfirmButton: false,
            timer: 5000,
        });
    });

    $(window).scroll(function () {
        didScroll = true;
    });

    setInterval(function() {
        if (didScroll) {
            hasScrolled();
            didScroll = false;
        }
    }, 250);

    function hasScrolled() {
        var st = $(this).scrollTop();
        if (Math.abs(lastScrollTop - st) <= delta) {
            return;
        }
        if (st > lastScrollTop && st > navbarHeight) {
            $('header').removeClass('nav-down').addClass('nav-up');
        } else {
            if(st + $(window).height() < $(document).height()) {
                $('header').removeClass('nav-up').addClass('nav-down');
            }
        }
        lastScrollTop = st;
    }

    $('[data-toggle="tooltip"]').tooltip();

    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    var url = window.location.href;

    if (url.indexOf("#") > 0) {
        var activeTab = url.substring(url.indexOf("#") + 1);
        if ($('.nav[role="tablist"] a[href="#'+activeTab+'"]').length) {
            $('.nav[role="tablist"] a[href="#'+activeTab+'"]').tab('show');
            $([document.documentElement, document.body]).animate({
                scrollTop: $('.nav[role="tablist"] a[href="#'+activeTab+'"]').closest('.nav-anchor').offset().top
            }, 250);
        }
    }

    if ($('#userCouponCategoriesconsumer').length) {
        $('#userCouponCategoriesconsumer div.collapse').eq(0).collapse('show');
    }

    if ($('#userCouponCategoriesagent').length) {
        $('#userCouponCategoriesagent div.collapse').eq(0).collapse('show');
    }

    var toggleFav = function (dealId) {
        $.post('/fav/' + dealId);
    };

    var unfav = function (dealId) {
        $('#dealUnfavForm').attr('action', '/unfav/' + dealId).submit();
    };

    $('#sellerReviewsCount a').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        $('.nav-link[href="#reviews"]').click();
        $([document.documentElement, document.body]).animate({
            scrollTop: $('#sellerContent').closest('.nav-anchor').offset().top
        }, 250);
    });

    $('div.deal-fav').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        $(this).toggleClass('active');

        var favsCount = parseInt($('#favsCounter').text()) || 0;
        if ( $(this).hasClass('active') ) {
            favsCount++;
        } else {
            favsCount--;
        }
        $('#favsCounter').text(favsCount > 0 ? favsCount : '');

        toggleFav($(this).closest('.deal').data('deal-id'));
    });

    $('div.deal-unfav').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var dealId = $(this).closest('.deal').data('deal-id');

        swal({
            title: 'Bist du sicher?',
            text: 'Sie können das nicht rückgängig machen!',
            type: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Löschen',
            cancelButtonText: 'Nein',
        }).then((result) => {
            if (result.value) {
                unfav(dealId);
            }
        });
    });

    var couponDelete = function (couponId) {
        return fetch('/api/coupon/' + couponId, {
            headers: {
                'Accept' : 'application/json',
            },
            method: 'DELETE',
        }).then(response => {
            if (response.ok) {
                location.reload();
            }
            if (401 === response.status || 422 === response.status) {
                return response.json().then(err => {throw err;});
            }
        }).catch(error => {
            swal.showValidationMessage(_processAPIError(error).join('<br>'));
        });
    };

    $('div.coupon-delete').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var couponId = $(this).data('coupon-id');

        swal({
            title: 'Bist du sicher?',
            text: 'Sie können das nicht rückgängig machen!',
            type: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Löschen',
            cancelButtonText: 'Nein',
        }).then((result) => {
            if (result.value) {
                couponDelete(couponId);
            }
        });
    });

    $('.deal-provision .deal-gift').on('mouseenter', function () {
        var p = $(this).closest('.deal');
        p.find('.deal-provision-gift').addClass('opened');
    });

    $('.deal-provision .deal-gift').on('mouseleave', function () {
        var p = $(this).closest('.deal');
        p.find('.deal-provision-gift').removeClass('opened');
    });

    $('.deal-cashback .deal-gift').on('mouseenter', function () {
        var p = $(this).closest('.deal');
        p.find('.deal-cashback-gift').addClass('opened');
    });

    $('.deal-cashback .deal-gift').on('mouseleave', function () {
        var p = $(this).closest('.deal');
        p.find('.deal-cashback-gift').removeClass('opened');
    });

    $('.coupon-provision .deal-gift').on('mouseenter', function () {
        var p = $(this).closest('.coupon');
        p.find('.coupon-provision-gift').addClass('opened');
    });

    $('.coupon-provision .deal-gift').on('mouseleave', function () {
        var p = $(this).closest('.coupon');
        p.find('.coupon-provision-gift').removeClass('opened');
    });

    $('.coupon-cashback .deal-gift').on('mouseenter', function () {
        var p = $(this).closest('.coupon');
        p.find('.coupon-cashback-gift').addClass('opened');
    });

    $('.coupon-cashback .deal-gift').on('mouseleave', function () {
        var p = $(this).closest('.coupon');
        p.find('.coupon-cashback-gift').removeClass('opened');
    });

    $(document).on('click', 'div.dealGetCashbackBtn', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var attr = $(this).attr('data-deal-id');

        if (typeof attr !== typeof undefined && attr !== false) {
            var dealId = $(this).data('deal-id');
        } else {
            var dealId = $(this).closest('.deal').data('deal-id');
        }

        dealGetCashback(dealId);
    });

    $('[data-share="email"]').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var link = $(this).data('link');
        var entity = $(this).data('entity');
        var entityId = $(this).data('entity-id');

        shareReferralLinkViaEmail(link, entity, entityId);
    });

    $('[data-provider]').on('click', function () {
        var entity = $(this).data('entity');
        var entityId = $(this).data('entity-id');
        var provider = $(this).data('provider');

        registerShare(entity, entityId, provider);
    });

    $('.showCoupon').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var couponId = $(this).data('coupon-id');

        showCoupon(couponId);
    });

    $(document).on('click', '.rateCoupon', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var couponId = $(this).data('coupon-id');

        rateCoupon(couponId);
    });

    $(document).on('mouseenter', '.ratingInput .rate', function () {
        $(this).prevAll('.rate').addClass('hover');
        $(this).addClass('hover');
        $(this).closest('.ratingInput').find('.ratingInputTitle').text($(this).data('title'));
    });

    $(document).on('mouseleave', '.ratingInput .rate', function () {
        $(this).closest('.ratingInput').find('.rate').removeClass('hover');
        var el = $(this).closest('.ratingInput').find('.rate.active').last();
        var title = el.length ? el.data('title') : 'Nicht Bewertet';
        $(this).closest('.ratingInput').find('.ratingInputTitle').text(title);
    });

    $(document).on('click', '.ratingInput .rate', function () {
        $(this).closest('.ratingInput').find('.rate').removeClass('active');
        $(this).prevAll('.rate').addClass('active');
        $(this).addClass('active');
        $(this).closest('.ratingInput').find('.ratingInputTitle').text($(this).data('title'));
    });

    function registerShare(entity, entityId, provider) {
        if (!entity || !entityId) {
            return;
        }

        fetch('/api/share/register', {
            body: JSON.stringify({
                entity: entity,
                id: entityId,
                provider: provider,
            }),
            headers: {
                'Accept' : 'application/json',
            },
            method: 'POST',
        });
    }

    async function shareReferralLinkViaEmail(link, entity, entityId) {
        swal({
            title: 'E-Mail deines Freundes',
            input: 'text',
            confirmButtonText: 'Jetzt empfehlen',
            showLoaderOnConfirm: true,
            preConfirm: (email) => {
                if (!email.length) {
                    swal.showValidationMessage('E-Mail Adresse muss ausgefüllt sein.');
                } else if (!_validateEmail(email)) {
                    swal.showValidationMessage('E-Mail Adresse muss eine gültige E-Mail-Adresse sein.');
                } else {
                    return fetch('/api/share_reflink/email', {
                        body: JSON.stringify({
                            link: link,
                            email: email,
                        }),
                        headers: {
                            'Accept' : 'application/json',
                        },
                        method: 'POST',
                    }).then(response => {
                        if (response.ok) {
                            return response.json();
                        }
                        if (401 === response.status || 422 === response.status) {
                            return response.json().then(err => {throw err;});
                        }
                    }).catch(error => {
                        swal.showValidationMessage(_processAPIError(error).join('<br>'));
                    });
                }
            },
            allowOutsideClick: () => !swal.isLoading()
        }).then(result => {
            if (result.value) {
                registerShare(entity, entityId, 'email');
                swal({
                    type: 'success',
                    title: 'Vielen Dank für Deine Empfehlung!',
                });
            }
        });
    }

    function dealGetCashback(dealId) {
        swal({
            title: 'Coupon jetzt aktivieren?',
            text: 'Du erhältst einen RECO.BON',
            type: 'question',
            showCancelButton: true,
            confirmButtonText: 'Ja',
            cancelButtonText: 'Nein',
            allowOutsideClick: () => !swal.isLoading(),
            showLoaderOnConfirm: true,
            preConfirm: () => {
                return fetch('/api/deal/' + dealId + '/getcashback/', {
                    headers: {
                        'Accept' : 'application/json',
                    },
                    method: 'POST',
                }).then(response => {
                    if (response.ok) {
                        return response.json();
                    }
                    if (401 === response.status || 422 === response.status) {
                        return response.json().then(err => {throw err;});
                    }
                }).catch(error => {
                    swal.showValidationMessage(_processAPIError(error).join('<br>'));
                })
            }
        }).then(result => {
            if (result.value) {
                showCouponCode(result.value.success);
            }
        });
    }

    function showCouponCode(data) {
        swal({
            'type': 'success',
            'title': 'Mit diesem Code erhälst Du beim Einkauf das Cashback!',
            'html':
                '<div class="coupon-barcode pt-5"><img src="data:image/png;base64,' + data.barcode + '"></div>' +
                '<div class="coupon-code pb-5">' + data.code + '</div>' +
                '<div><a class="btn btn-secondary" href="/coupons">Zum RECO.BONs</a></div>',
        });
    }

    function showCoupon(couponId) {
        fetch('/coupon/' + couponId + '/view')
            .then(response => {
                if (response.ok) {
                    return response.text();
                }
            })
            .then(result => {
                swal({
                    html: result,
                });
            });
    }

    function getRatingInput() {
        var html =
            '<div id="rateCouponRatingInput" class="ratingInput">' +
                '<div class="ratingInputStars">' +
                    '<div class="rate" data-value="1" data-title="Ungenügend"><i class="fas fa-star"></i></div>' +
                    '<div class="rate" data-value="2" data-title="Mangelhaft"><i class="fas fa-star"></i></div>' +
                    '<div class="rate" data-value="3" data-title="Akzeptabel"><i class="fas fa-star"></i></div>' +
                    '<div class="rate" data-value="4" data-title="Gut"><i class="fas fa-star"></i></div>' +
                    '<div class="rate" data-value="5" data-title="Hervorragend"><i class="fas fa-star"></i></div>' +
                '</div>' +
                '<div class="ratingInputTitle">' +
                    '<span>Nicht Bewertet</span>' +
                '</div>' +
            '</div>';

        return html;
    }

    function rateCoupon(couponId) {
        swal({
            title: 'Bitte bewerten einen RECO.BON',
            html: getRatingInput(),
            input: 'textarea',
            showCancelButton: true,
            allowOutsideClick: () => !swal.isLoading(),
            showLoaderOnConfirm: true,
            preConfirm: (text) => {
                var ratingEl = $('#rateCouponRatingInput .rate.active').last();
                if ( !ratingEl.length ) {
                    swal.showValidationMessage('Wählen Sie die Bewertung.');
                } else if (!text.length) {
                    swal.showValidationMessage('Bewertung muss ausgefüllt sein.');
                } else {
                    return fetch('/api/coupon/' + couponId + '/rate/', {
                        body: JSON.stringify({
                            rating: parseInt(ratingEl.data('value')),
                            text: text,
                        }),
                        headers: {
                            'Accept': 'application/json',
                        },
                        method: 'POST',
                    }).then(response => {
                        if (response.ok) {
                            return response.json();
                        }
                        if (401 === response.status || 422 === response.status) {
                            return response.json().then(err => {
                                throw err;
                            });
                        }
                    }).catch(error => {
                        swal.showValidationMessage(_processAPIError(error).join('<br>'));
                    })
                }
            }
        }).then(result => {
            if (result.value) {
                location.reload();
            }
        });
    }

    $("#userProfilePictureInput").on('change', function() {
        var input = this;
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                $('#userProfilePicture').css('background-image', 'url(' + e.target.result + ')');
                $('#userProfilePictureChangeBtnsHolder').hide();
                $('#userProfilePictureUploadBtnsHolder').show();
            };
            reader.readAsDataURL(input.files[0]);
        }
    });

    $('#userProfilePictureChangeBtn, #userProfilePicture').on('click', function () {
        $('#userProfilePictureInput').click();
    });

    $('#userProfilePictureCancelBtn').on('click', function () {
        $('#userProfilePictureChangeBtnsHolder').show();
        $('#userProfilePictureUploadBtnsHolder').hide();
        $('#userProfilePicture').css('background-image',  $('#userProfilePicture').data('bg'));
    });

    $('#userProfilePictureUploadBtn').on('click', function () {
        $('#userProfilePictureForm').submit();
    });

    $('.userProfileEditable form').on('submit', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var p = $(this).closest('.userProfileSection');
        userProfileSend(p);
    });

    function userProfileOpen(p) {
        p.find('.userProfileStatic').hide();
        p.find('.userProfileEditable').show();
    }

    function userProfileClose(p) {
        p.find('.userProfileStatic').show();
        p.find('.userProfileEditable').hide();
        userProfileErrorsHide(p);
        userProfileLoadingHide(p);
    }

    function userProfileErrorsHide(p) {
        p.find('.userProfileError').hide();
        p.find('input').removeClass('border-danger');
    }

    function userProfileClear(p) {
        p.find('.userProfileInput[data-clearable]').val('');
    }

    function userProfileLoadingShow(p) {
        p.find('.userProfileOverlay').show();
    }

    function userProfileLoadingHide(p) {
        p.find('.userProfileOverlay').hide();
    }

    function userProfileSuccess() {
        swal({
            type: 'success',
            title: 'Daten wurden erfolgreich geändert',
            toast: true,
            position: 'bottom-end',
            showConfirmButton: false,
            timer: 5000,
        });
    }

    function userProfileError(p, data) {
        userProfileErrorsHide(p)
        userProfileLoadingHide(p);
        var bag = data.error || data;
        for (key in bag) {
            var input = p.find('[name="' + key + '"]');
            if (input.length) {
                input.addClass('border-danger');
            }
            var msg = p.find('[data-input="' + key + '"]');
            if (msg.length) {
                msg.show().text(bag[key][0]);
            }
        }
    }

    function userProfileAttachData(p) {
        var els = p.find('[data-binded]');
        els.each(function () {
            var binded = $(this).data('binded');
            var el = p.find('.userProfileInput[name="' + binded + '"]');
            if (el.length) {
                $(this).val(el.val());
            }
        });
    }

    function userProfileSend(p) {
        var form = p.find('form[action]').first();
        var inputs = form.find('.userProfileInput');
        var data = {};
        inputs.each(function () {
            data[$(this).attr('name')] =  $(this).val();
        });
        userProfileLoadingShow(p);
        fetch(form.attr('action'), {
            body: JSON.stringify(data),
            headers: {
                'Accept': 'application/json',
            },
            method: 'POST',
        }).then(response => {
            if (response.ok) {
                userProfileClose(p);
                userProfileAttachData(p);
                userProfileClear(p);
                userProfileSuccess();
            }
            if (401 === response.status || 422 === response.status) {
                return response.json().then(err => {
                    throw err;
                });
            }
        }).catch(error => {
            userProfileError(p, error);
        });
    }

    function showGift(name, image) {
        swal({
            title: name,
            imageUrl: image,
        });
    }

    function getGiftAddressInputs(giftId) {
        var el = $('.setGiftAddress[data-gift-id="' + giftId + '"]');
        var zip = el.data('zip') || $('#addressZip').val().trim();
        var city = el.data('city') || $('#addressCity').val().trim();
        var street = el.data('street') || $('#addressStreet').val().trim();
        var house = el.data('house') || $('#addressHouse').val().trim();
        var comment = el.data('comment') || '';
        var html =
            '<div class="form-group">' +
                '<input type="text" class="form-control" id="giftAddressZip" placeholder="PLZ" value="' + zip + '">' +
            '</div>' +
            '<div class="form-group">' +
                '<input type="text" class="form-control" id="giftAddressCity" placeholder="Ort" value="' + city + '">' +
            '</div>' +
            '<div class="form-group">' +
                '<input type="text" class="form-control" id="giftAddressStreet" placeholder="Straße" value="' + street + '">' +
            '</div>' +
            '<div class="form-group">' +
                '<input type="text" class="form-control" id="giftAddressHouse" placeholder="Hausnummer" value="' + house + '">' +
            '</div>' +
            '<div class="form-group">' +
                '<textarea class="form-control" id="giftAddressComment" placeholder="Kommentar">' + comment + '</textarea>' +
            '</div>';
        return html;
    }

    function setGiftAddress(giftId) {
        swal({
            title: 'Bitte geben Sie Ihre Adresse ein',
            html: getGiftAddressInputs(giftId),
            showCancelButton: true,
            allowOutsideClick: () => !swal.isLoading(),
            showLoaderOnConfirm: true,
            preConfirm: () => {
                var zip = $('#giftAddressZip').val().trim();
                var city = $('#giftAddressCity').val().trim();
                var street = $('#giftAddressStreet').val().trim();
                var house = $('#giftAddressHouse').val().trim();
                var comment = $('#giftAddressComment').val().trim();
                if (!zip.length) {
                    swal.showValidationMessage('PLZ muss ausgefüllt sein.');
                } else if (!city.length) {
                    swal.showValidationMessage('Ort muss ausgefüllt sein.');
                } else if (!street.length) {
                    swal.showValidationMessage('Straße muss ausgefüllt sein.');
                } else if (!house.length) {
                    swal.showValidationMessage('Hausnummer muss ausgefüllt sein.');
                } else {
                    return fetch('/api/usersgift/' + giftId + '/setaddress/', {
                        body: JSON.stringify({
                            zip: zip,
                            city: city,
                            street: street,
                            house: house,
                            comment: comment,
                        }),
                        headers: {
                            'Accept': 'application/json',
                        },
                        method: 'POST',
                    }).then(response => {
                        if (response.ok) {
                            return response.json();
                        }
                        if (401 === response.status || 422 === response.status) {
                            return response.json().then(err => {
                                throw err;
                            });
                        }
                    }).catch(error => {
                        swal.showValidationMessage(_processAPIError(error).join('<br>'));
                    })
                }
            }
        }).then(result => {
            if (result.value) {
                location.reload();
            }
        });
    }

    function setGiftReceived(giftId) {
        fetch('/api/usersgift/' + giftId + '/received/', {
            headers: {
                'Accept': 'application/json',
            },
            method: 'POST',
        }).then(response => {
            location.reload();
        });
    }

    function addFiltersToLink(link) {
        var currentURL = new URL(location.href);
        var url = new URL(link);

        if ( null !== currentURL.searchParams.get('sort') ) {
            url.searchParams.set('sort', currentURL.searchParams.get('sort'));
        }

        return url.href;
    }

    $('.userProfileEditBtn').on('click', function () {
        var p = $(this).closest('.userProfileSection');
        userProfileOpen(p);
    });

    $('.userProfileCancelBtn').on('click', function () {
        var p = $(this).closest('.userProfileSection');
        userProfileClose(p);
    });

    $('.userProfileSaveBtn').on('click', function () {
        var p = $(this).closest('.userProfileSection');
        userProfileSend(p);
    });

    $('#payoutBtnMock').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        swal('Du kannst aktuell noch keine Auszahlung vornehmen');
    });

    $('.topCategory').hover(function () {
        $(this).addClass('shadow');
    }, function () {
        $(this).removeClass('shadow');
    });

    $('#topCategoriesInner').draggable({
        axis: 'x',
        drag: function(event, ui) {
            var left = ui.position.left,
                offsetWidth = ($(this).width() - $(this).parent().width()) * -1;

            if (left > 0) {
                ui.position.left = 0;
            }
            if (offsetWidth > left) {
                ui.position.left = offsetWidth;
            }
        }
    });

    $('.showGift').on('click', function () {
        var name = $(this).data('name');
        var image = $(this).data('image');
        showGift(name, image);
    });

    $('.setGiftAddress').on('click', function () {
        var giftId = $(this).data('gift-id');
        setGiftAddress(giftId);
    });

    $('.setGiftReceived').on('click', function () {
        var giftId = $(this).data('gift-id');

        swal({
            title: 'Bist du sicher?',
            text: 'Sie können das nicht rückgängig machen!',
            type: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Markieren',
            cancelButtonText: 'Nein',
        }).then((result) => {
            if (result.value) {
                setGiftReceived(giftId);
            }
        });
    });

    if ( $('#couponsTabs').length ) {
        $('#couponsTabs .nav-item').eq(0).find('a').click()
    }

    function geoFindMe() {
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(function (position) {
                var lat = position.coords.latitude;
                var lon = position.coords.longitude;
                var protocol = window.location.protocol;
                var hostname = window.location.hostname;
                var link = protocol + '//' + hostname + '/deals/?lat=' + lat + '&lon=' + lon;
                location.href = addFiltersToLink(link);
            }, function () {
                swal("Geolocation wird abgelehnt.", '', 'error');
            });
        } else {
            swal("Geolocation wird von diesem Browser nicht unterstützt.", '', 'error');
        }
    }

    function geoRenderCitiesMarkup(cities) {
        var protocol = window.location.protocol;
        var hostname = window.location.hostname;
        var html = '';
        for (i in cities) {
            var link = addFiltersToLink(protocol + '//' + hostname + '/deals/?lat=' + cities[i].lat + '&lon=' + cities[i].lon + '&city=' + cities[i].name + '&plz=' + cities[i].zip + '&loc_id=' + cities[i].loc_id);
            html +=
                '<div class="geoResultItem geoResultCity">' +
                    '<a href="' + link + '">' +
                        '<div class="geoResultItemIcon"><i class="fas fa-map-pin"></i></div>' +
                        '<div class="geoResultItemName"><span>' + cities[i].zip + '</span>' + cities[i].name + '</div>' +
                    '</a>' +
                '</div>';
        }
        return html;
    }

    function geoRenderCities(results) {
        if ( !results.length ) {
            $('#geoTooltip').show().text('Wir konnten diesen Standort nicht gefunden.');
            $('#geoResultsHolder').hide();
            $('#geoLastSearches').show();
        } else {
            var cities = geoRenderCitiesMarkup(results);
            $('#geoTooltip').hide();
            $('#geoResultsHolder').show();
            $('#geoResults').html(cities);
            $('#geoLastSearches').hide();
        }
    }

    function geoFindCity(str) {
        geoResultCurrent = -1;
        $('.geoResultItem').removeClass('active');
        if ('undefined' !== typeof geoResultsCache['c_' + str]) {
            geoRenderCities(geoResultsCache['c_' + str]);
            oldCityFieldStr = str;
        } else {
            geoRequest = $.ajax('/api/cities/find', {
                type: 'post',
                data: {
                    str: str,
                },
                dataType: 'json',
                beforeSend: function () {
                    if (geoRequest != null) {
                        geoRequest.abort();
                    }
                },
                success: function (response) {
                    geoResultsCache['c_' + str] = response.success;
                    geoRenderCities(response.success);
                    oldCityFieldStr = str;
                },
            });
        }
    }

    function geoGoToSelected() {
        var item = $('.geoResultItem.active');
        if ( item.length ) {
            var a = item.find('a');
            if (a.length) {
                a.click();
            } else {
                $('.geoResultItem.active').click();
            }
        }
    }

    $('#geoFindMeBtn').on('click', function () {
        geoFindMe();
    });

    $('#geoInput').on('keyup', function (e) {
        if (e.which == 27 || e.keyCode == 27) {
            $(this).blur();
            geoResultsHide();
        }

        if (e.which == 13 || e.keyCode == 13) {
            geoGoToSelected();
        }

        var str = $(this).val().trim();
        if (str.length >= 3) {
            if (oldCityFieldStr !== str) {
                $('#geoTooltip').show().text('Warte bitte...');
                $('#geoResultsHolder').hide();
                geoFindCity(str);
            }
        } else {
            $('#geoTooltip').show().text('Beginne zu tippen');
            $('#geoResultsHolder').hide();
            $('#geoLastSearches').show();
            oldCityFieldStr = '';
        }
    });

    function geoResultsShow() {
        $('#geoBody').show();
    }

    function geoResultsHide() {
        $('#geoBody').hide();
    }

    function geoResultSelectPrev() {
        var l = $('.geoResultItem:visible').length;
        if ( l ) {
            if (-1 === geoResultCurrent) {
                geoResultCurrent = l - 1;
            } else {
                geoResultCurrent -= 1;
                if (geoResultCurrent < 0) {
                    geoResultCurrent = l - 1;
                }
            }

            $('.geoResultItem').removeClass('active');
            $('.geoResultItem:visible').eq(geoResultCurrent).addClass('active');
        }
    }

    function geoResultSelectNext() {
        var l = $('.geoResultItem:visible').length;
        if ( l ) {
            if (-1 === geoResultCurrent) {
                geoResultCurrent = 0;
            } else {
                geoResultCurrent += 1;
                if (geoResultCurrent >= l) {
                    geoResultCurrent = 0;
                }
            }

            $('.geoResultItem').removeClass('active');
            $('.geoResultItem:visible').eq(geoResultCurrent).addClass('active');
        }
    }

    $('#geoInput').on('keydown', function (e) {
        if (e.which == 38 || e.keyCode == 38) {
            geoResultSelectPrev();
            return false;
        }

        if (e.which == 40 || e.keyCode == 40) {
            geoResultSelectNext();
            return false;
        }
    });

    $('#geoInput').on('focus', function () {
        geoResultsShow();
    });

    $('#geoInput').on('blur', function () {
        geoResultsHide();
    });

    $('#sortingSelect').on('changed.bs.select', function (e, clickedIndex, isSelected, previousValue) {
        var link = $(this).find('option').eq(clickedIndex).data('link');
        location.href = link;
    });

    $(document).on('mousedown', '#geoFindMeBtn', function (e) {
        e.preventDefault();
        e.stopPropagation();

        geoResultsHide();
        geoFindMe();
    });

    $(document).on('mousedown click', '.geoResultItem > a', function (e) {
        e.preventDefault();
        e.stopPropagation();

        geoResultsHide();
        location.href = addFiltersToLink($(this).attr('href'));
    });

    function searchResultsRenderDeals(list) {
        var l = list.length;
        var html = '';
        for (i = 0; i < l; i++) {
            var item = list[i];
            html +=
                '<div class="searchResultItem searchResultDeal">' +
                    '<a href="' + item.link + '">' +
                        '<div class="searchResultItemImage searchResultDealImage" style="background-image:url(' + item.image + ')"></div>' +
                        '<div class="searchResultItemName searchResultDealName">' + item.title + ' bei ' + item.seller + '</div>' +
                    '</a>' +
                '</div>';
        }
        return html;
    }

    function searchResultsRenderSellers(list) {
        var l = list.length;
        var html = '';
        for (i = 0; i < l; i++) {
            var item = list[i];
            html +=
                '<div class="searchResultItem searchResultSeller">' +
                    '<a href="' + item.link + '">' +
                        '<div class="searchResultItemImage searchResultSellerLogo" style="background-image:url(' + item.logo + ')"></div>' +
                        '<div class="searchResultItemName searchResultSellerName">' + item.company + '</div>' +
                    '</a>' +
                '</div>';
        }
        return html;
    }

    function searchResultsRenderCategories(list) {
        var l = list.length;
        var html = '';
        for (i = 0; i < l; i++) {
            var item = list[i];
            html +=
                '<div class="searchResultItem searchResultCategory">' +
                    '<a href="' + item.link + '">' +
                        '<div class="searchResultItemIcon searchResultCategoryIcon"><i class="far fa-folder-open"></i></div>' +
                        '<div class="searchResultItemName searchResultCategoryName">' + item.name + '</div>' +
                    '</a>' +
                '</div>';
        }
        return html;
    }

    function searchResultsRender(results) {
        if ( !results.deals.length && !results.sellers.length && !results.categories.length ) {
            $('#searchTooltip').show().text('Tut uns leid. Nicths gefunden.');
            $('#searchResults').hide();
        } else {
            var deals = searchResultsRenderDeals(results.deals);
            var sellers = searchResultsRenderSellers(results.sellers);
            var categories = searchResultsRenderCategories(results.categories);
            $('#searchTooltip').hide();
            $('#searchResults').show().html(deals + sellers + categories);
        }
    }

    function searchApply(q) {
        searchResultCurrent = -1;
        $('.searchResultItem').removeClass('active');
        if ('undefined' !== typeof searchResultsCache['s_' + q]) {
            searchResultsRender(searchResultsCache['s_' + q]);
            oldSearchStr = q;
        } else {
            searchRequest = $.ajax('/api/search', {
                type: 'post',
                data: {
                    q: q,
                },
                dataType: 'json',
                beforeSend: function () {
                    if (searchRequest != null) {
                        searchRequest.abort();
                    }
                },
                success: function (response) {
                    searchResultsCache['s_' + q] = response.success;
                    searchResultsRender(response.success);
                    oldSearchStr = q;
                }
            });
        }
    }

    function searchOpenPage() {
        if ( $('.searchResultItem.active').length ) {
            location.href = $('.searchResultItem.active a').attr('href');
        } else {
            var q = $('#searchInput').val().trim();
            if (q.length >= 3) {
                location.href = '/search?q=' + q;
            }
        }
    }

    function searchResultsShow() {
        $('#searchBody').show();
    }

    function searchResultsHide() {
        $('#searchBody').hide();
        $('.searchResultItem').removeClass('active');
        searchResultCurrent = -1;
    }

    function searchResultSelectPrev() {
        var l = $('.searchResultItem').length;
        if ( l ) {
            if (-1 === searchResultCurrent) {
                searchResultCurrent = l - 1;
            } else {
                searchResultCurrent -= 1;
                if (searchResultCurrent < 0) {
                    searchResultCurrent = l - 1;
                }
            }

            $('.searchResultItem').removeClass('active');
            $('.searchResultItem').eq(searchResultCurrent).addClass('active');
        }
    }

    function searchResultSelectNext() {
        var l = $('.searchResultItem').length;
        if ( l ) {
            if (-1 === searchResultCurrent) {
                searchResultCurrent = 0;
            } else {
                searchResultCurrent += 1;
                if (searchResultCurrent >= l) {
                    searchResultCurrent = 0;
                }
            }

            $('.searchResultItem').removeClass('active');
            $('.searchResultItem').eq(searchResultCurrent).addClass('active');
        }
    }

    $('#searchInput').on('keydown', function (e) {
        if (e.which == 38 || e.keyCode == 38) {
            searchResultSelectPrev();
            return false;
        }

        if (e.which == 40 || e.keyCode == 40) {
            searchResultSelectNext();
            return false;
        }
    });

    $('#searchInput').on('keyup', function (e) {
        if (e.which == 13 || e.keyCode == 13) {
            searchOpenPage();
        }

        if (e.which == 27 || e.keyCode == 27) {
            $(this).blur();
            searchResultsHide();
        }

        var q = $(this).val().trim();
        if (q.length >= 3) {
            if (oldSearchStr !== q) {
                $('#searchTooltip').show().text('Warte bitte...');
                $('#searchResults').hide().text('');
                searchApply(q);
            }
        } else {
            $('#searchTooltip').show().text('Beginne zu tippen');
            $('#searchResults').hide().text('');
            oldSearchStr = '';
        }
    });

    $('#searchInput').on('focus', function () {
        searchResultsShow();
    });

    $('#searchInput').on('blur', function () {
        searchResultsHide();
    });

    $('#searchInputButton').on('click', function () {
        searchOpenPage();
    });

    $(document).on('mousedown', '.searchResultItem > a', function (e) {
        e.preventDefault();
        e.stopPropagation();

        searchResultsHide();
        location.href = $(this).attr('href');
    });

    $('#searchInputToggler').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        $('body').addClass('modal-open');
        $('#searchControlsHolder').show();
        $('#searchInput').focus();
    });

    $('#geoInputToggler').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        $('body').addClass('modal-open');
        $('#searchControlsHolder').show();
        $('#geoInput').focus();
    });

    $('#searchControlsClose').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        $('body').removeClass('modal-open');
        $('#searchControlsHolder').hide();
    });

    function searchResize() {
        var wh = $(window).height();
        var mh = $('#bar:visible').length ? 200 : 100;
        var nh = wh - mh;
        $('#geoBody, #searchBody').css('max-height', nh + 'px');
    };

    $(window).on('resize', searchResize);

    setTimeout(searchResize, 100);

    $('.deal-gallery')
        .slick({
            prevArrow: '<div class="deal-btn slider-prev"><i class="far fa-arrow-alt-circle-left"></i></div>',
            nextArrow: '<div class="deal-btn slider-next"><i class="far fa-arrow-alt-circle-right"></i></div>',
        })
        .on('lazyLoaded', function (e, slick, image, imageSource) {
            image.parent().css('background-image', 'url("' + imageSource + '")');
            image.hide();
        }).on('beforeChange', function (e, slick, currentSlide, nextSlide) {
            var slide = $(slick.$slides[nextSlide]);
            if (!slide.hasClass('hasvideo')) {
                dealVideoPause();
            }
        }).on('afterChange', function (e, slick, currentSlide) {
            var slide = $(slick.$slides[currentSlide]);
            if (slide.hasClass('hasvideo')) {
                dealVideoPlay(slide.closest('.deal'));
            }
        });

    $('#dealTabs ul li a[href="#others"]').on('click', function () {
        setTimeout(function () {
            $('.deal-gallery').slick('setPosition');
        }, 500);
    });

    function dealVideoInit(deal) {
        var v = deal.find('.hasvideo');
        var url = v.data('video');
        v.append('<video loop muted autoplay><source src="' + url + '" type="video/mp4"></video>');
    };

    function dealVideoPlay(deal) {
        dealVideoPause();

        var video = deal.find('video');
        if ( !video.length ) {
            dealVideoInit(deal);
        } else {
            video[0].play();
        }
    };

    function dealVideoPause() {
        $('video').each(function () {
            $(this)[0].pause();
        })
    };

    $(document).on('click', '.deal-footer, .deal-gallery-item', function () {
        var deal = $(this).closest('.deal');
        var link = deal.data('link');
        location.href = link;
    });

    $(document).on('mouseenter', '.deal', function (e) {
        e.preventDefault();
        e.stopPropagation();

        if ( $(this).find('.slick-current.hasvideo').length ) {
            dealVideoPlay($(this));
        }
    });

    $(document).on('mouseleave', '.deal', function (e) {
        e.preventDefault();
        e.stopPropagation();

        dealVideoPause($(this));
    });

    $('.deal-gallery-item').on('lazyloaded', function (e) {
        var el = $(e.target);
        var id = el.data('item');
        var slider = el.closest('.slick-track');
        var bg = el.css('background-image');
        slider.find('.slick-cloned[data-item="' + id + '"]').css('background-image', bg);
    });

    $('#userProfileRemoveAgreement').on('change', function () {
        if ( $(this).prop('checked') ) {
            $('#userProfileRemoveBtn').removeAttr('disabled');
        } else {
            $('#userProfileRemoveBtn').attr('disabled', 'disabled');
        }
    });

    function dealVideoAutoplay() {
        if ( isTouchDevice() && $(window).width() < 900 ) {
            var deal = null;
            $('.deal-gallery:visible').each(function () {
                if ( $(this).isInViewportFully() ) {
                    deal = $(this).closest('.deal');
                }
            });
            if (deal) {
                dealVideoPlay(deal);
            }
        }
    };

    function removeProfile() {
        fetch('/api/user/remove/', {
            headers: {
                'Accept': 'application/json',
            },
            method: 'POST',
        }).then(response => {
            location.href = '/';
        });
    };

    function removeProfileConfirm() {
        swal({
            title: 'Bist du sicher?',
            text: 'Wir fragen dich das letzte Mal!',
            type: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Ja',
            cancelButtonText: 'Nein',
            focusConfirm: false,
            focusCancel: true,
        }).then((result) => {
            if (result.value) {
                removeProfile();
            } else {
                $('#userProfileRemoveAgreement').prop('checked', false);
                $('#userProfileRemoveToggler').click();
            }
        });
    };

    $('#userProfileRemoveBtn').on('click', removeProfileConfirm);

    function payPalUnbind() {
        location.href = '/paypal/disconnect';
    };

    function payPalUnbindConfirm() {
        swal({
            title: 'Bist du sicher?',
            text: '',
            type: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Ja',
            cancelButtonText: 'Nein',
            focusConfirm: false,
            focusCancel: true,
        }).then((result) => {
            if (result.value) {
                payPalUnbind();
            }
        });
    };

    $('#userProfilePayPalUnbindBtn').on('click', payPalUnbindConfirm);

    $(window).scroll(dealVideoAutoplay);

    dealVideoAutoplay();
});