var updateLatLon = function (event) {
    document.getElementById('dcLatInput').value = event.latLng.lat();
    document.getElementById('dcLonInput').value = event.latLng.lng();
};

var mapInit = function () {
    var map = new google.maps.Map(document.getElementById('dcMap'), {
        center: {lat: markerCoords.lat, lng: markerCoords.lon},
        zoom: 10,
        mapTypeId: 'roadmap'
    });

    var marker;

    var addMarker = function (position) {
        marker = new google.maps.Marker({
            position: position,
            map: map,
            animation: google.maps.Animation.DROP,
            draggable: true,
        });
        marker.addListener('drag', updateLatLon);
        marker.addListener('dragend', updateLatLon);
    };

    addMarker({lat: markerCoords.lat, lng: markerCoords.lon});

    var input = document.getElementById('dcMapSearchInput');
    var searchBox = new google.maps.places.SearchBox(input);
    map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);

    map.addListener('bounds_changed', function() {
        searchBox.setBounds(map.getBounds());
    });

    searchBox.addListener('places_changed', function() {
        var places = searchBox.getPlaces();

        if (places.length == 0) {
            return;
        }

        marker.setMap(null);

        var bounds = new google.maps.LatLngBounds();

        addMarker(places[0].geometry.location);
        document.getElementById('dcLatInput').value = places[0].geometry.location.lat();
        document.getElementById('dcLonInput').value = places[0].geometry.location.lng();

        if (places[0].geometry.viewport) {
            bounds.union(places[0].geometry.viewport);
        } else {
            bounds.extend(places[0].geometry.location);
        }

        map.fitBounds(bounds);
    });
};

$.fn.isInViewport = function() {
    var elementTop = $(this).offset().top;
    var elementBottom = elementTop + $(this).outerHeight();
    var viewportTop = $(window).scrollTop();
    var viewportBottom = viewportTop + $(window).height();
    return elementBottom > viewportTop && elementTop < viewportBottom;
};

$.fn.isInViewportFully = function() {
    var elementTop = $(this).offset().top;
    var elementBottom = elementTop + $(this).outerHeight();
    var viewportTop = $(window).scrollTop();
    var viewportBottom = viewportTop + $(window).height();
    return elementTop >= viewportTop && elementBottom <= viewportBottom;
};

$(document).ready(function () {
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    var dcValiditySlider = document.getElementById('dcValidity');

    noUiSlider.create(dcValiditySlider, {
        range: {min: 1, max: 24},
        start: [dcValiditySlider.getAttribute('data-value')],
        step: 1,
        tooltips: true,
        margin: 300,
        format: {
            to: function (value) {
                var m = Math.round(parseFloat(value));
                return m + (1 === m ? ' Monat' : ' Monate');
            },
            from: function (value) {
                return value;
            }
        },
    });

    $('#dcQuota').TouchSpin({
        min: 1,
        max: 10000,
        step: 1,
        buttonup_class: 'btn btn-default',
        buttondown_class: 'btn btn-default',
        buttonup_txt: '<i class="fa fa-chevron-up"></i>',
        buttondown_txt: '<i class="fa fa-chevron-down"></i>',
    });

    $('#dcCashbackPercentInput').TouchSpin({
        min: 1,
        max: 100,
        step: 1,
        buttonup_class: 'btn btn-default',
        buttondown_class: 'btn btn-default',
        buttonup_txt: '<i class="fa fa-chevron-up"></i>',
        buttondown_txt: '<i class="fa fa-chevron-down"></i>',
    });

    $('#dcPremiumPercentInput').TouchSpin({
        min: 1,
        max: 100,
        step: 1,
        buttonup_class: 'btn btn-default',
        buttondown_class: 'btn btn-default',
        buttonup_txt: '<i class="fa fa-chevron-up"></i>',
        buttondown_txt: '<i class="fa fa-chevron-down"></i>',
    });

    new Cleave('#dcCashbackAmountInput', {
        numeral: true,
        numeralDecimalMark: ',',
        delimiter: '.'
    });

    new Cleave('#dcPremiumAmountInput', {
        numeral: true,
        numeralDecimalMark: ',',
        delimiter: '.'
    });

    $('#dcGalleryDropZone').sortable({
        containment: 'parent',
        handle: '.dcGalleryMove',
        items: '.dcGalleryItem',
        placeholder: 'dcGalleryItemPlaceholder',
    });

    var catMasonry = $('#dcCatList').masonry({
        itemSelector: '.dcCatWrapper',
        columnWidth: 320
    });

    $.noty.defaults.theme = 'bootstrapTheme';
    $.noty.defaults.layout = 'bottomRight';
    $.noty.defaults.timeout = 5000;

    var dcVideoLoading = false;
    var dcGalleryLoading = 0;
    var dcGalleryMax = 10;
    var dcGallerySlider = null;

    var scrollTo = function (el) {
        $('html, body').animate({
            scrollTop: el.offset().top - $('#dashboardHeader').height()
        }, 300);
    };

    var dcSetActive = function (el) {
        $('#dcMenu > span').removeClass('active');
        el.addClass('active');
    };

    var calcVisibleHeight = function (el) {
        var scrollTop = $(window).scrollTop(),
            scrollBot = scrollTop + $(window).height(),
            elTop = el.offset().top,
            elBottom = elTop + el.outerHeight(),
            visibleTop = elTop < scrollTop ? scrollTop : elTop,
            visibleBottom = elBottom > scrollBot ? scrollBot : elBottom;
        return visibleBottom - visibleTop;
    };

    var dcSyncMenu = function () {
        var steps = $('.dcStep');
        var l = steps.length;
        var visible = [];
        for (var i = 0; i < l; i++) {
            if ( $(steps[i]).isInViewport() ) {
                visible.push(steps[i]);
            }
        }
        if (1 === visible.length) {
            dcSetActive($('#dcMenu > span[data-step="' + $(visible[0]).attr('id') + '"]'));
        } else {
            var l = visible.length;
            var list = [];
            for (var i = 0; i < l; i++) {
                var ve = $(visible[i]);
                var eh = ve.height();
                var vh = calcVisibleHeight(ve);
                var vp = vh / eh;
                list.push({
                    'el' : ve,
                    'p' : vp,
                });
            }
            list.sort(function (a, b) {
                if (a.p > b.p) { return -1; }
                if (a.p < b.p) { return 1; }
                return 0;
            });
            dcSetActive($('#dcMenu > span[data-step="' + $(list[0].el).attr('id') + '"]'));
        }
    };

    var dcShowStep = function (el) {
        var step = $('#' + el.data('step'));
        if (step.length) {
            scrollTo(step);
        }
    };

    var dcPrepareCashback = function () {
        var type = $('input[name="dcCashbackType"]:checked').val();
        if ('gift' === type) {
            $('#dcDealPreviewCashbackValue .value').html('Ein Geschenk');
            $('#dcDealPreviewCashbackValue .unit').html('als');
        } else if ('percent' === type) {
            $('#dcDealPreviewCashbackValue .value').html($('#dcCashbackPercentInput').val().trim() || '&nbsp;');
            $('#dcDealPreviewCashbackValue .unit').html('%');
        } else {
            $('#dcDealPreviewCashbackValue .value').html($('#dcCashbackAmountInput').val().trim() || '&nbsp;');
            $('#dcDealPreviewCashbackValue .unit').html('&euro;');
        }
    };

    var dcPreparePremium = function () {
        var type = $('input[name="dcPremiumType"]:checked').val();
        if ('none' === type) {
            $('#dcDealPreviewPremiumValue').hide();
        } else {
            $('#dcDealPreviewPremiumValue').show();
            if ('gift' === type) {
                $('#dcDealPreviewPremiumValue .value').html('Ein Geschenk');
                $('#dcDealPreviewPremiumValue .unit').html('als');
            } else if ('percent' === type) {
                $('#dcDealPreviewPremiumValue .value').html($('#dcPremiumPercentInput').val().trim() || '&nbsp;');
                $('#dcDealPreviewPremiumValue .unit').html('%');
            } else {
                $('#dcDealPreviewPremiumValue .value').html($('#dcPremiumAmountInput').val().trim() || '&nbsp;');
                $('#dcDealPreviewPremiumValue .unit').html('&euro;');
            }
        }
    };

    var dcPrepareImage = function () {
        var img = $('#dcGalleryDropZone .dcGalleryItem.success').length
            ? $('#dcGalleryDropZone .dcGalleryItem.success').eq(0).data('img')
            : '';

        $('#dcDealPreviewImage').attr('src', img);
    };

    function dealVideoInit(deal) {
        var v = deal.find('.hasvideo');
        var url = v.data('video');
        v.append('<video loop muted autoplay><source src="' + url + '" type="video/mp4"></video>');
    };

    function dealVideoPlay(deal) {
        dealVideoPause();

        var video = deal.find('video');
        if ( !video.length ) {
            dealVideoInit(deal);
        } else {
            video[0].play();
        }
    };

    function dealVideoPause() {
        $('video').each(function () {
            $(this)[0].pause();
        })
    };

    var dcPreparePreview = function () {
        $('#dcDealPreviewTitle').html($('#dcTitleInput').val().trim() || '&nbsp;');
        dcPrepareCashback();
        dcPreparePremium();
        dcPrepareImage();
    };

    var dcShowPreview = function () {
        dcPreparePreview();
        $('body').addClass('modal-open');
        $('#dcDealPreviewHolder').show();
    };

    var dcProcessValidationError = function (key, error) {
        var el = $('[data-name="' + key + '"]');
        if (el.length) {
            var p = el.closest('.inputHolder');
            p.addClass('hasError');
            p.find('.err').text(error);
        }
    };

    var dcMarkMenuItemsWithErrors = function () {
        $('.dcMenuItem').removeClass('hasErrors');
        $('.dcStep').each(function () {
            var id = $(this).attr('id');
            var errCount = $(this).find('.hasError').length;
            if (errCount) {
                $('.dcMenuItem[data-step="' + id + '"]').addClass('hasErrors');
            }
        });
    };

    var dcProcessValidationErrors = function (errors) {
        for (key in errors) {
            dcProcessValidationError(key, errors[key]);
        }
        dcMarkMenuItemsWithErrors();
        if ( $('.hasError').length ) {
            scrollTo($('.hasError').eq(0).closest('.dcStep'));
        }
    };

    var getCashbackValue = function () {
        var type = $('input[name="dcCashbackType"]:checked').val();
        if ('percent' === type) {
            return $('#dcCashbackPercentInput').val().trim();
        }
        if ('amount' === type) {
            return $('#dcCashbackAmountInput').val().trim();
        }
        return 0;
    };

    var getPremiumValue = function () {
        var type = $('input[name="dcPremiumType"]:checked').val();
        if ('percent' === type) {
            return $('#dcPremiumPercentInput').val().trim();
        }
        if ('amount' === type) {
            return $('#dcPremiumAmountInput').val().trim();
        }
        return 0;
    };

    var getVideoItems = function () {
        var videoItems = [];
        $('#dcVideoDropZone .dcVideoItem').each(function () {
            videoItems.push($(this).data('id'));
        });
        return videoItems;
    };

    var getGalleryItems = function () {
        var galleryItems = [];
        $('#dcGalleryDropZone .dcGalleryItem.success').each(function () {
            galleryItems.push($(this).data('id'));
        });
        return galleryItems;
    };

    var collectPlaces = function () {
        var places = [];
        $('.dcPlaceItemCheckbox:checked').each(function () {
            places.push($(this).val());
        });
        return places;
    };

    var dcGetFormData = function () {
        return {
            deal_id: dealId,
            title: $('#dcTitleInput').val().trim(),
            description: $('#dcDescriptionInput').val().trim(),
            quota: $('#dcQuota').val(),
            validity: parseInt(dcValiditySlider.noUiSlider.get()) || 0,
            terms: $('#dcTermsInput').val().trim(),
            category_id: $('.dcCatItem.selected').data('id'),
            type_discount: $('input[name="dcCashbackType"]:checked').val(),
            discount_consumer: getCashbackValue(),
            discount_gift_id: $('#dcStepCashback .dcGiftItem.selected').data('id') || null,
            type_provision: $('input[name="dcPremiumType"]:checked').val(),
            provision_agent: getPremiumValue(),
            provision_gift_id: $('#dcStepPremium .dcGiftItem.selected').data('id') || null,
            places: collectPlaces(),
            video: getVideoItems(),
            gallery: getGalleryItems(),
        };
    };

    var dcUpdate = function (onSuccess) {
        if (dcVideoLoading || dcGalleryLoading) {
            swal('Bitte warte, Upload läuft');
            return;
        }

        $('.hasError').removeClass('hasError');
        $('#overlay').show();

        $.ajax({
            url: '/api/deal/update/',
            method: 'POST',
            dataType: 'json',
            data: dcGetFormData(),
            success: function (response) {
                $('#overlay').hide();
                onSuccess();
            },
            error: function (response) {
                $('#overlay').hide();
                dcProcessValidationErrors(response.responseJSON);
            },
        });
    };

    var dcCatListExpand = function () {
        $('#dcCatListToggler').removeClass('collapsed');
        $('#dcCatListHolder').show();
        catMasonry.masonry('layout');
    };

    var dcCatListCollapse = function () {
        $('#dcCatListToggler').addClass('collapsed');
        $('#dcCatListHolder').hide();
    };

    var dcCatListToggle = function () {
        if ( $('#dcCatListToggler').hasClass('collapsed') ) {
            dcCatListExpand();
        } else {
            dcCatListCollapse();
        }
    };

    var dcSelectCategory = function (el) {
        $('.dcCatItem').removeClass('selected');
        el.addClass('selected');
        $('#dcSelectedCategoryHolder').show();
        $('#dcSelectedCategoryPath').text(el.data('chain') + ' / ');
        $('#dcSelectedCategoryName').text(el.data('name'));
        $('#dcStepCategory .hasError').removeClass('hasError');
        dcMarkMenuItemsWithErrors();
    };

    var dcCatSearch = function (s) {
        s = s.toLowerCase();
        s = s.replace(/\s/g, '');
        s = s.replace(/[,-]/g, '');
        s = s.replace(/\u00fc/g, 'ue');
        s = s.replace(/\u00e4/g, 'ae');
        s = s.replace(/\u00f6/g, 'oe');
        s = s.replace(/\u00df/g, 'ss');

        $('.dcCatItem, .dcCatWrapper').removeClass('d-none');
        $('#dcCatNothingFound').hide();

        $('.dcCatItem[data-leaf="1"]').each(function () {
            var searchString = $(this).data('search');
            if ( -1 === searchString.indexOf(s) ) {
                $(this).addClass('d-none');
            }
        });

        $('.dcCatItem[data-leaf="0"]').each(function () {
            var items = $(this).find('.dcCatItem[data-leaf="1"]').not('.d-none');
            if ( !items.length ) {
                $(this).addClass('d-none');
            }
        });

        $('.dcCatWrapper').each(function () {
            var items = $(this).find('.dcCatItem').not('.d-none');
            if ( !items.length ) {
                $(this).addClass('d-none');
            }
        });

        $('.dcCatItem[data-leaf="1"]').unmark({
            done: function() {
                $('.dcCatItem[data-leaf="1"]').mark(s);
            }
        });

        dcCatListExpand();
        catMasonry.masonry('layout');

        if ( !$('.dcCatWrapper').not('.d-none').length ) {
            $('#dcCatNothingFound').show();
        }
    };

    var dcCatSearchReset = function () {
        $('#dcCatSearchInput').val('');
        $('.dcCatItem, .dcCatWrapper').removeClass('d-none');
        dcCatListCollapse();
        catMasonry.masonry('layout');
    };

    var dcGiftSelect = function (el) {
        var container = el.closest('.dcStep');
        var gifts = container.find('.dcGiftItem');
        gifts.removeClass('selected');
        el.addClass('selected');
        el.closest('.inputHolder').removeClass('hasError');
        dcMarkMenuItemsWithErrors();
    };

    var dcViewToggle = function (el) {
        var name = el.attr('name');
        var list = $('input[name="' + name + '"]:checked').data('show').split(',');
        var parent = el.closest('.dcViewTogglerHolder');
        parent.find('.dcView').hide();
        var l = list.length;
        for (var i = 0; i < l; i++) {
            var el = $('#' + list[i]);
            parent.find('.hasError').removeClass('hasError');
            el.show();
            dcMarkMenuItemsWithErrors();
        }
    };

    var dcVideoRemove = function () {
        dcVideoLoading = false;
        $('#dcVideoDropZone .dcVideoItem').remove();
        $('#dcVideoDropZoneTitle').show();
    };

    var dcGalleryRemove = function (el) {
        el.closest('.dcGalleryItem').remove();
        if ( !$('#dcGalleryDropZone .dcGalleryItem').length ) {
            $('#dcGalleryDropZoneTitle').show();
        }
    };

    var dcGalleryPreview = function (el) {
        var img = el.closest('.dcGalleryItem').data('img');
        $('body').addClass('modal-open');
        $('#dcGalleryPreviewImage').attr('src', img);
        $('#dcGalleryPreviewHolder').show();
    };

    var dcGalleryPreviewClose = function () {
        $('body').removeClass('modal-open');
        $('#dcGalleryPreviewImage').attr('src', '');
        $('#dcGalleryPreviewHolder').hide();
    };

    var dcGalleryDealPreviewClose = function () {
        $('body').removeClass('modal-open');
        $('#dcDealPreviewHolder').hide();
    };

    var dcVideoAdd = function (data) {
        dcVideoRemove();
        dcVideoLoading = true;
        $('#dcVideoDropZoneTitle').hide();
        var item = $('#dcVideoItemTemplate').clone(true).attr('id', '');
        $('#dcVideoDropZone').append(item);
    };

    var dcGalleryAdd = function (data) {
        //
    };

    var dcVideoAlways = function (data) {
        var index = data.index;
        var file = data.files[index];
        if (file.error) {
            swal(file.error, '', 'error');
            dcVideoRemove();
        }
    };

    var dcGalleryAlways = function (data) {
        var file = data.files[0];
        if (file.error) {
            noty({
                type: 'error',
                text: file.name + ': ' + file.error,
            });
        } else {
            dcGalleryLoading++;
            $('#dcStepGallery .hasError').removeClass('hasError');
            dcMarkMenuItemsWithErrors();
            $('#dcGalleryDropZoneTitle').hide();
            var item = $('#dcGalleryItemTemplate').clone(true).attr('id', '');
            $('#dcGalleryDropZone').append(item);
            $('#dcGalleryDropZone').sortable('refresh');
        }
    };

    var dcVideoFail = function (data) {
        var response = data.jqXHR.responseJSON;
        swal(response.video[0], '', 'error');
        dcVideoRemove();
    };

    var dcGalleryFail = function (data) {
        var file = data.files[0];
        var response = data.jqXHR.responseJSON;
        var el = $('#dcGalleryDropZone .dcGalleryItem.loading').eq(0);
        el.remove();
        noty({
            type: 'error',
            text: file.name + ': ' + response.image[0],
        });
        dcGalleryLoading--;
    };

    var dcVideoSuccess = function (data) {
        var response = data.jqXHR.responseJSON.success;
        dcVideoLoading = false;
        var el = $('#dcVideoDropZone .dcVideoItem');
        el.removeClass('loading').addClass('success');
        el.attr('data-id', response.id);
        el.attr('data-video', response.url);
        el.attr('data-poster', response.small);
        el.find('video').attr('src', response.url);
    };

    var dcGallerySuccess = function (data) {
        var response = data.jqXHR.responseJSON.success;
        var el = $('#dcGalleryDropZone .dcGalleryItem.loading').eq(0);
        el.removeClass('loading').addClass('success');
        el.attr('data-id', response.id);
        el.attr('data-img', response.url);
        el.find('.dcGalleryImage').css('background-image', 'url("' + response.url + '")');
        dcGalleryLoading--;
    };

    var dcGalleryFileCountRestrict = function (e, data) {
        var existed = $('#dcGalleryDropZone .dcGalleryItem').length;
        if (existed >= dcGalleryMax) {
            e.preventDefault();
            noty({
                type: 'warning',
                text: 'Nicht mehr 10 Bilder bitte!',
            });
        } else {
            var dropped = data.files.length;
            if (existed + dropped >= dcGalleryMax) {
                data.files.length = dcGalleryMax - existed;
                noty({
                    type: 'warning',
                    text: 'Nicht mehr 10 Bilder bitte!',
                });
            }
        }
    };

    $('#dcMenu > span').on('click', function () {
        dcShowStep($(this));
    });

    $('.dcViewToggler').on('change', function () {
        dcViewToggle($(this));
    });

    $(document).on('focus click change', '.hasError input', function () {
        $(this).closest('.hasError').removeClass('hasError');
        if ( $(this).closest('.dcViewTogglerHolder').length ) {
            $(this).closest('.dcViewTogglerHolder').find('.dcView.hasError:not(visible)').removeClass('hasError');
        }
        dcMarkMenuItemsWithErrors();
    });

    $('.dcPreview').on('click', dcShowPreview);

    $('.dcCreate, .dcSaveAndExit').on('click', function () {
        dcUpdate(function () {
            swal({
                title: 'Der RECO.BON wurde erfolgreich erstellt',
                type: 'success',
                heightAuto: false
            }).then((result) => {
                window.location.href = $('.dcCancel').attr('href');
            });
        });
    });

    $('.dcSaveAndStay').on('click', function () {
        dcUpdate(function () {
            swal({
                title: 'Der RECO.BON wurde erfolgreich gespeichert',
                type: 'success',
                heightAuto: false
            });
        });
    });

    $('.dcCatItem[data-leaf="1"]').on('click', function () {
        if ( !$(this).hasClass('selected') ) {
            dcSelectCategory($(this));
        }
    });

    $('#dcCatSearchInput').on('change keyup', function () {
        dcCatSearch($(this).val().trim());
    });

    $('#dcCatSearchReset').on('click', dcCatSearchReset);

    $('.dcGiftItem').on('click', function () {
        dcGiftSelect($(this));
    });

    $('#dcVideoFileInput').fileupload({
        url: '/api/upload/',
        dataType: 'json',
        formData: {
            deal_id: dealId,
        },
        autoUpload: true,
        acceptFileTypes: /(\.|\/)(mp4)$/i,
        maxFileSize: 10 * 1024 * 1024,
        dropZone: $('#dcVideoDropZone'),
        messages: {
            maxNumberOfFiles: 'Nur eine Videodatei bitte!',
            acceptFileTypes: 'Videodatei muss den Dateityp mp4 haben',
            maxFileSize: 'Videodatei darf maximal 10 Mb groß sein',
        }
    }).on('fileuploadadd', function (e, data) {
        dcVideoAdd(data);
    }).on('fileuploadprocessalways', function (e, data) {
        dcVideoAlways(data);
    }).on('fileuploaddone', function (e, data) {
        dcVideoSuccess(data);
    }).on('fileuploadfail', function (e, data) {
        dcVideoFail(data);
    }).on('fileuploaddrop', function (e, data) {
        if (data.files.length > 1) {
            e.preventDefault();
            swal('Nur eine Videodatei bitte!', '', 'error');
        }
    }).prop('disabled', !$.support.fileInput)
        .parent().addClass($.support.fileInput ? undefined : 'disabled');

    $('#dcGalleryFileInput').fileupload({
        url: '/api/upload/',
        dataType: 'json',
        formData: {
            deal_id: dealId,
        },
        autoUpload: true,
        acceptFileTypes: /(\.|\/)(gif|jpe?g|png)$/i,
        maxFileSize: 500 * 1024,
        dropZone: $('#dcGalleryDropZone'),
        messages: {
            maxNumberOfFiles: 'Nicht mehr 10 Bilder bitte!',
            acceptFileTypes: 'Datei muss den Bild Dateityp haben',
            maxFileSize: 'Bild darf maximal 500 Kb groß sein',
        },
        change: function (e, data) {
            dcGalleryFileCountRestrict(e, data);
        }
    }).on('fileuploadadd', function (e, data) {
        dcGalleryAdd(data);
    }).on('fileuploadprocessalways', function (e, data) {
        dcGalleryAlways(data);
    }).on('fileuploaddone', function (e, data) {
        dcGallerySuccess(data);
    }).on('fileuploadfail', function (e, data) {
        dcGalleryFail(data);
    }).on('fileuploaddrop', function (e, data) {
        dcGalleryFileCountRestrict(e, data);
    }).prop('disabled', !$.support.fileInput)
        .parent().addClass($.support.fileInput ? undefined : 'disabled');

    $(document).on('dragover', function (e) {
        var dropZones = $('.dropzone'),
            timeout = window.dropZoneTimeout;
        if (timeout) {
            clearTimeout(timeout);
        } else {
            dropZones.addClass('in');
        }
        var hoveredDropZone = $(e.target).closest(dropZones);
        dropZones.not(hoveredDropZone).removeClass('hover');
        hoveredDropZone.addClass('hover');
        window.dropZoneTimeout = setTimeout(function () {
            window.dropZoneTimeout = null;
            dropZones.removeClass('in hover');
        }, 100);
    });

    $(document).on('drop dragover', function (e) {
        e.preventDefault();
    });

    $('#dcVideoDropZone').on('click', function (e) {
        if ( !$(e.target).closest('.dcVideoItem').length ) {
            $('#dcVideoFileInput').click();
        }
    });

    $(document).on('click', '.dcVideoRemove', function () {
        dcVideoRemove();
    });

    $('#dcGalleryDropZone').on('click', function (e) {
        if ( !$(e.target).closest('.dcGalleryItem').length ) {
            $('#dcGalleryFileInput').click();
        }
    });

    $(document).on('click', '.dcGalleryRemove', function () {
        dcGalleryRemove($(this));
    });

    $(document).on('click', '.dcGalleryPreview', function () {
        dcGalleryPreview($(this));
    });

    $('#dcGalleryPreviewHolder').on('click', function () {
        dcGalleryPreviewClose();
    });

    $('#dcDealPreviewHolder').on('click', function (e) {
        if ( !$(e.target).closest('#dcGalleryPreviewDealInner').length ) {
            dcGalleryDealPreviewClose();
        }
    });

    $('#dcGalleryDealPreviewClose').on('click', function () {
        dcGalleryDealPreviewClose();
    });

    $('#dcPreviewFav').on('click', function () {
        $(this).toggleClass('active');
    });

    $('.deal-provision .deal-gift').on('mouseenter', function () {
        var p = $(this).closest('.deal');
        p.find('.deal-provision-gift').addClass('opened');
    });

    $('.deal-provision .deal-gift').on('mouseleave', function () {
        var p = $(this).closest('.deal');
        p.find('.deal-provision-gift').removeClass('opened');
    });

    $('.deal-cashback .deal-gift').on('mouseenter', function () {
        var p = $(this).closest('.deal');
        p.find('.deal-cashback-gift').addClass('opened');
    });

    $('.deal-cashback .deal-gift').on('mouseleave', function () {
        var p = $(this).closest('.deal');
        p.find('.deal-cashback-gift').removeClass('opened');
    });

    $(document).on('mouseenter', '.deal', function (e) {
        e.preventDefault();
        e.stopPropagation();

        if ( $(this).find('.slick-current.hasvideo').length ) {
            dealVideoPlay($(this));
        }
    });

    $(document).on('mouseleave', '.deal', function (e) {
        e.preventDefault();
        e.stopPropagation();

        dealVideoPause($(this));
    });

    $('#dcCatListToggler').on('click', function () {
        dcCatListToggle();
    });

    var dcPlacesCheckBoxesState = function () {
        $('#dcStepPlace .hasError').removeClass('hasError');
        dcMarkMenuItemsWithErrors();

        if ( $('.dcPlaceItemCheckbox:checked').length === $('.dcPlaceItemCheckbox').length ) {
            $('#dcPlaceItemAll').prop('checked', true);
        }

        if ( !$('.dcPlaceItemCheckbox:checked').length) {
            $('#dcPlaceItemAll').prop('checked', false);
        }
    };

    var dcPlacesCheckboxesSwitch = function (state) {
        $('.dcPlaceItemCheckbox').prop('checked', state);
        dcPlacesCheckBoxesState();
    };

    $('#dcPlaceItemAll').on('change', function () {
        dcPlacesCheckboxesSwitch($(this).prop('checked'));
    });

    $('.dcPlaceItemCheckbox').on('change', function () {
        dcPlacesCheckBoxesState();
    });

    $(window).on('scroll', dcSyncMenu);

    dcSyncMenu();

    $('#overlay').hide();
});