var _validateEmail = function (email) {
    var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return re.test(String(email).toLowerCase());
};

var _processAPIError = function (data) {
    var text = [];
    var bag = data.error || data;
    if ('object' === typeof bag) {
        for (i in bag) {
            text.push(bag[i]);
        }
    } else if ('undefined' !== typeof bag) {
        text.push(bag);
    } else {
        text.push(data);
    }
    return text;
};

$(document).ready(function () {
    var APIcall = function (url, data, onSuccess, onError) {
        $.ajax(url, {
            type: 'post',
            data: data,
            dataType: 'json',
            success: function (response) {
                onSuccess(response);
            },
            error: function (error) {
                onError(error);
            },
        });
    };

    var helpTour = $('body').attr('data-tour') || '';

    var clipboard = new ClipboardJS('.clipboard');

    clipboard.on('success', function(e) {
        e.clearSelection();

        swal({
            type: 'success',
            title: 'Erfolgreich kopiert',
            toast: true,
            position: 'bottom-end',
            showConfirmButton: false,
            timer: 5000,
        });
    });

    $('[data-toggle="tooltip"]').tooltip();

    function showGift(name, image) {
        swal({
            title: name,
            imageUrl: image,
            heightAuto: false,
        });
    }

    $(document).on('click', '.showGift', function (e) {
        e.preventDefault();
        var name = $(this).data('name');
        var image = $(this).data('image');
        showGift(name, image);
    });

    var searchItems = function (el) {
        var s = el.val().trim();
        var scope = $(el.data('search-scope'));
        var holder = $(el.data('search-holder'));
        var nothing = $(el.data('search-nothing'));
        
        s = s.replace(/\s/g, '');

        nothing.hide();
        holder.show();
        scope.show();

        scope.each(function () {
            var searchString = $(this).data('search');
            if ( -1 === searchString.indexOf(s) ) {
                $(this).hide();
            }
        });

        scope.unmark({
            done: function() {
                scope.mark(s);
            }
        });

        if ( scope.closest('.table-striped').length ) {
            scope.filter(':visible').each(function (index) {
                $(this).css("background-color", !!(index & 1)? "rgba(0,0,0,0)" : "rgba(0,0,0,.05)");
            });
        }

        if ( !scope.filter(':visible').length ) {
            nothing.show();
            holder.hide();
        }
    };

    $('input[data-search-scope]').on('change keyup', function () {
        searchItems($(this));
    });

    $('[data-search-reset]').on('click', function () {
        $($(this).data('search-reset')).val('').change();
    });

    $(document).on('click', '.showItemInfo', function () {
        var modal = $('#' + $(this).data('mid'));
        modal.modal('show');
    });

    $('#userProfilePictureInput').on('change', function() {
        var input = this;
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                $('#userProfilePicture').css('background-image', 'url(' + e.target.result + ')');
                $('#userProfilePictureChangeBtnsHolder').hide();
                $('#userProfilePictureUploadBtnsHolder').show();
            };
            reader.readAsDataURL(input.files[0]);
        }
    });

    $('#userProfilePictureChangeBtn, #userProfilePicture').on('click', function () {
        $('#userProfilePictureInput').click();
    });

    $('#userProfilePictureCancelBtn').on('click', function () {
        $('#userProfilePictureInput').val(null);
        $('#userProfilePictureChangeBtnsHolder').show();
        $('#userProfilePictureUploadBtnsHolder').hide();
        $('#userProfilePicture').css('background-image',  $('#userProfilePicture').data('bg'));
    });

    $('#userProfilePictureUploadBtn').on('click', function () {
        $('#userProfilePictureForm').submit();
    });

    $('#sellerLogoInput').on('change', function() {
        var input = this;
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                $('#sellerProfileLogo').css('background-image', 'url(' + e.target.result + ')');
                $('#sellerLogoChangeBtnsHolder').hide();
                $('#sellerLogoUploadBtnsHolder').show();
            };
            reader.readAsDataURL(input.files[0]);
        }
    });

    $('#sellerLogoChangeBtn, #sellerProfileLogo').on('click', function () {
        $('#sellerLogoInput').click();
    });

    $('#sellerLogoCancelBtn').on('click', function () {
        $('#sellerLogoInput').val(null);
        $('#sellerLogoChangeBtnsHolder').show();
        $('#sellerLogoUploadBtnsHolder').hide();
        $('#sellerProfileLogo').css('background-image',  $('#sellerProfileLogo').data('bg'));
    });

    $('#sellerLogoUploadBtn').on('click', function () {
        $('#sellerLogoForm').submit();
    });

    $('#sellerPictureInput').on('change', function() {
        var input = this;
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                $('#sellerPicture').css('background-image', 'url(' + e.target.result + ')');
                $('#sellerPictureChangeBtnsHolder').hide();
                $('#sellerPictureUploadBtnsHolder').show();
            };
            reader.readAsDataURL(input.files[0]);
        }
    });

    $('#sellerPictureChangeBtn, #sellerPicture').on('click', function () {
        $('#sellerPictureInput').click();
    });

    $('#sellerPictureCancelBtn').on('click', function () {
        $('#sellerPictureInput').val(null);
        $('#sellerPictureChangeBtnsHolder').show();
        $('#sellerPictureUploadBtnsHolder').hide();
        $('#sellerPicture').css('background-image',  $('#sellerPicture').data('bg'));
    });

    $('#sellerPictureUploadBtn').on('click', function () {
        $('#sellerPictureForm').submit();
    });
    
    $('.userProfileEditable form').on('submit', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var p = $(this).closest('.userProfileSection');
        userProfileSend(p);
    });

    function userProfileOpen(p) {
        p.find('.userProfileStatic').hide();
        p.find('.userProfileEditable').show();
    }

    function userProfileClose(p) {
        p.find('.userProfileStatic').show();
        p.find('.userProfileEditable').hide();
        userProfileErrorsHide(p);
        userProfileLoadingHide(p);
    }

    function userProfileErrorsHide(p) {
        p.find('.userProfileError').hide();
        p.find('input').removeClass('border-danger');
    }

    function userProfileClear(p) {
        p.find('.userProfileInput[data-clearable]').val('');
    }

    function userProfileLoadingShow(p) {
        p.find('.userProfileOverlay').show();
    }

    function userProfileLoadingHide(p) {
        p.find('.userProfileOverlay').hide();
    }

    function userProfileSuccess() {
        swal({
            type: 'success',
            title: 'Daten wurden erfolgreich geändert',
            toast: true,
            position: 'bottom-end',
            showConfirmButton: false,
            timer: 5000,
        });
    }

    function userProfileError(p, data) {
        userProfileErrorsHide(p)
        userProfileLoadingHide(p);
        var bag = data.error || data;
        for (key in bag) {
            var input = p.find('[name="' + key + '"]');
            if (input.length) {
                input.addClass('border-danger');
            }
            var msg = p.find('[data-input="' + key + '"]');
            if (msg.length) {
                msg.show().text(bag[key][0]);
            }
        }
    }

    function userProfileAttachData(p) {
        var els = p.find('[data-binded]');
        els.each(function () {
            var binded = $(this).data('binded');
            var el = p.find('.userProfileInput[name="' + binded + '"]');
            if (el.length) {
                $(this).val(el.val());
            }
        });
        p.removeClass('profileSectionEmpty').addClass('profileSectionFilled');
    }

    function userProfileSend(p) {
        var form = p.find('form[action]').first();
        var inputs = form.find('.userProfileInput');
        var reload = form.data('reload') || false;
        var data = {};
        inputs.each(function () {
            data[$(this).attr('name')] =  $(this).val();
        });
        userProfileLoadingShow(p);
        fetch(form.attr('action'), {
            body: JSON.stringify(data),
            headers: {
                'Accept': 'application/json',
            },
            method: 'POST',
        }).then(response => {
            if (response.ok) {
                userProfileClose(p);
                userProfileAttachData(p);
                userProfileClear(p);
                if (reload) {
                    location.reload();
                } else {
                    userProfileSuccess();
                }
            }
            if (401 === response.status || 422 === response.status) {
                return response.json().then(err => {
                    throw err;
                });
            }
        }).catch(error => {
            userProfileError(p, error);
        });
    }

    async function shareReferralLinkViaEmail(link) {
        swal({
            title: 'E-Mail Adresse eingeben',
            heightAuto: false,
            input: 'text',
            confirmButtonText: 'Jetzt empfehlen',
            showLoaderOnConfirm: true,
            preConfirm: (email) => {
                if (!email.length) {
                    swal.showValidationMessage('E-Mail Adresse muss ausgefüllt sein.');
                } else if (!_validateEmail(email)) {
                    swal.showValidationMessage('E-Mail Adresse muss eine gültige E-Mail-Adresse sein.');
                } else {
                    return fetch('/api/share_reflink/email', {
                        body: JSON.stringify({
                            link: link,
                            email: email,
                        }),
                        headers: {
                            'Accept' : 'application/json',
                        },
                        method: 'POST',
                    }).then(response => {
                        if (response.ok) {
                            return response.json();
                        }
                        if (401 === response.status || 422 === response.status) {
                            return response.json().then(err => {throw err;});
                        }
                    }).catch(error => {
                        swal.showValidationMessage(_processAPIError(error).join('<br>'));
                    });
                }
            },
            allowOutsideClick: () => !swal.isLoading()
        }).then(result => {
            if (result.value) {
                swal({
                    type: 'success',
                    title: 'Vielen Dank für Deine Empfehlung!',
                    heightAuto: false,
                });
            }
        });
    }

    $('.userProfileEditBtn').on('click', function () {
        var p = $(this).closest('.userProfileSection');
        userProfileOpen(p);
    });

    $('.userProfileCancelBtn').on('click', function () {
        var p = $(this).closest('.userProfileSection');
        userProfileClose(p);
    });

    $('.userProfileSaveBtn').on('click', function () {
        var p = $(this).closest('.userProfileSection');
        userProfileSend(p);
    });

    $('[data-share="email"]').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var link = $(this).data('link');

        shareReferralLinkViaEmail(link);
    });

    if (helpTour.length) {
        $('#startTourBtn').show();
    }

    var isFirstTimeHere = function () {
        return (helpTour.length && localStorage.getItem(helpTour) !== 'done');
    };

    var startTour = function () {
        introJs()
            .setOption('nextLabel', '&rarr;')
            .setOption('prevLabel', '&larr;')
            .setOption('skipLabel', 'überspringen')
            .setOption('doneLabel', 'klar!')
            .onexit(function () {
                localStorage.setItem(helpTour, 'done');
            })
            .start();
    };

    $('.startTourBtn').on('click', function () {
        startTour();
    });

    if ( isFirstTimeHere() ) {
        startTour();
    }

    $('#profileNewsletterSave').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var url = $('#profileNewsletter').prop('checked')
            ? '/api/newsletter/subscribe'
            : '/api/newsletter/unsubscribe';

        $('#userProfileSectionNewsletter .userProfileOverlay').show();

        APIcall(url, {}, function () {
            swal({
                type: 'success',
                title: 'Erfolgreich gespeichert',
                toast: true,
                position: 'bottom-end',
                showConfirmButton: false,
                timer: 5000,
            });
            $('#userProfileSectionNewsletter .userProfileOverlay').hide();
        });
    });

    if ( $('#swalMsg').length ) {
        swal($('#swalMsg').data('msg'), '', $('#swalMsg').data('type'));
    }

    $('#emailVerificationSend').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        $('#overlay').show();

        APIcall('/api/email/sendtoken', {}, function () {
            swal({
                type: 'success',
                title: 'Wir haben eine Bestätigungsmail mit einem Link gesendet.',
                toast: true,
                position: 'bottom-end',
                showConfirmButton: false,
                timer: 5000,
            });
            $('#overlay').hide();
        });
    });
});