jQuery(document).ready(function ($) {
    $('[data-toggle="tooltip"]').bstooltip();
    $('[data-autocomplete-source]').each(function (index, element) {
        $element = $(element);
        $element.autocomplete({
            source: $element.data('autocomplete-source')
        });
    });

    $('.adaptive-placeholder').each(function (index, element) {
        // manipulate placeholder forms
        $element = $(element);
        $element.attr('required', true);
        $element.parents('form').attr('novalidate', true);
        var label = $element.attr('placeholder');
        $element.removeAttr('placeholder');
        $element.after('<label placeholder="' + label + '" alt="' + label + '"></label>');
    });

    $('.place-input').each(function(index, element) {
        $element = $(element);
        $element.find('input').keydown(function() {
            if ($element.find('input').val()) {
                $element.find('select').parent().removeClass('fade-out');
            } else {
                $element.find('select').parent().addClass('fade-out');
            }
        }).keydown();
    });

    if ( $('.input-eur').length ) {
        new AutoNumeric('.input-eur', AutoNumeric.getPredefinedOptions().euroPos);
    }

    if ( $('.input-percent').length ) {
        new AutoNumeric('.input-percent', AutoNumeric.getPredefinedOptions().percentageEU2decPos);
    }

    $('[data-an-input]').on('autoNumeric:rawValueModified', function () {
        AutoNumeric.getNumericString($(this)[0], function (val, element) {
            var inp = $(element.domElement).attr('data-an-input');
            $(inp).val($(element.domElement).hasClass('input-percent') ? val * 100 : val);
        });
    });
});