<?php

use App\Account;
use App\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UsersTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $account = Account::where('company', '=', 'Operator Company Ltd.')->first();
        User::create([
            'account_id'    => $account['id'],
            'firstname'     => 'John',
            'surname'       => 'Operator',
            'email'         => 'operator@reco.ma',
            'mobile'        => '0123456789',
            'phone'         => '061235030',
            'fax'           => '061235030',
            'status'        => 'active',
            'password'      => Hash::make('dev'),
            'salutation'    => 'Herr',
            'email_verified'=> 1
        ]);

        $account = Account::where('company', '=', 'Seller Company Ltd.')->first();
        User::create([
            'account_id'    => $account['id'],
            'firstname'     => 'John',
            'surname'       => 'Seller',
            'email'         => 'seller@reco.ma',
            'mobile'        => '0123456789',
            'phone'         => '061235030',
            'fax'           => '061235030',
            'status'        => 'active',
            'password'      => Hash::make('dev'),
            'salutation'    => 'Herr',
            'mobile_verified' => 1,
            'email_verified' => 1,
        ]);

        $account = Account::where('company', '=', 'Seller For All Company Ltd.')->first();
        User::create([
            'account_id'    => $account['id'],
            'firstname'     => 'John',
            'surname'       => 'Seller For All',
            'email'         => 'seller_for_all@reco.ma',
            'mobile'        => '0123456789',
            'phone'         => '061235030',
            'fax'           => '061235030',
            'status'        => 'active',
            'password'      => Hash::make('dev'),
            'salutation'    => 'Herr',
            'mobile_verified' => 1,
            'email_verified' => 1,
        ]);

        $account = Account::where('company', '=', 'Agent Company Ltd.')->first();
        User::create([
            'firstname'     => 'John',
            'surname'       => 'Agent',
            'email'         => 'agent@reco.ma',
            'mobile'        => '0123456789',
            'phone'         => '061235030',
            'fax'           => '061235030',
            'status'        => 'active',
            'password'      => Hash::make('dev'),
            'salutation'    => 'Herr',
            'mobile_verified' => 1,
            'account_id'    => $account['id'],
            'email_verified'=> 1
        ]);

        $account = Account::where('iban_owner', '=', 'John Consumer')->first();
        User::create([
            'account_id'    => $account['id'],
            'firstname'     => 'John',
            'surname'       => 'Consumer',
            'email'         => 'consumer@reco.ma',
            'mobile'        => '0123456789',
            'phone'         => '061235030',
            'fax'           => '061235030',
            'status'        => 'active',
            'password'      => Hash::make('dev'),
            'salutation'    => 'Herr',
            'mobile_verified' => 1,
            'email_verified'=> 1
        ]);

        $account = Account::where('iban_owner', '=', 'Jane AgentConsumer')->first();
        User::create([
            'account_id'    => $account['id'],
            'firstname'     => 'Jane',
            'surname'       => 'AgentConsumer',
            'email'         => 'agent-consumer@reco.ma',
            'mobile'        => '0123456789',
            'phone'         => '061235030',
            'fax'           => '061235030',
            'status'        => 'active',
            'password'      => Hash::make('dev'),
            'salutation'    => 'Frau',
            'mobile_verified' => 1,
            'email_verified'=> 1
        ]);

        $account = Account::where('iban_owner', '=', 'Armin van ADM')->first();
        User::create([
            'account_id'    => $account['id'],
            'firstname'     => 'Armin',
            'surname'       => 'van ADM',
            'email'         => 'fieldservice_employee@reco.ma',
            'mobile'        => '0123456789',
            'phone'         => '061235030',
            'fax'           => '061235030',
            'status'        => 'active',
            'password'      => Hash::make('dev'),
            'salutation'    => 'Herr',
            'mobile_verified' => 1,
            'email_verified'=> 1
        ]);

        $account = Account::where('iban_owner', '=', 'Köln John')->first();
        User::create([
            'account_id'    => $account['id'],
            'firstname'     => 'Jonny',
            'surname'       => 'SellerKöln',
            'email'         => 'seller-koeln@web.de',
            'mobile'        => '0123456789',
            'phone'         => '061235030',
            'fax'           => '061235030',
            'status'        => 'active',
            'password'      => Hash::make('dev'),
            'salutation'    => 'Frau',
            'mobile_verified' => 1,
            'email_verified'=> 1
        ]);

        $account = Account::where('iban_owner', '=', 'Rüdesheim John')->first();
        User::create([
            'account_id'    => $account['id'],
            'firstname'     => 'Jonny',
            'surname'       => 'SellerRüdesheim',
            'email'         => 'seller-ruedesheim@web.de',
            'mobile'        => '0123456789',
            'phone'         => '061235030',
            'fax'           => '061235030',
            'status'        => 'active',
            'password'      => Hash::make('dev'),
            'salutation'    => 'Herr',
            'mobile_verified' => 1,
            'email_verified'=> 1
        ]);

        $account = Account::where('iban_owner', '=', 'Koblenz John')->first();
        User::create([
            'account_id'    => $account['id'],
            'firstname'     => 'Jonny',
            'surname'       => 'SellerKoblenz',
            'email'         => 'seller-koblenz@web.de',
            'mobile'        => '0123456789',
            'phone'         => '061235030',
            'fax'           => '061235030',
            'status'        => 'active',
            'password'      => Hash::make('dev'),
            'salutation'    => 'Herr',
            'mobile_verified' => 1,
            'email_verified'=> 1
        ]);

        $account = Account::where('iban_owner', '=', 'Neuwied John')->first();
        User::create([
            'account_id'    => $account['id'],
            'firstname'     => 'Jonny',
            'surname'       => 'SellerNeuwied',
            'email'         => 'seller-neuwied@web.de',
            'mobile'        => '0123456789',
            'phone'         => '061235030',
            'fax'           => '061235030',
            'status'        => 'active',
            'password'      => Hash::make('dev'),
            'salutation'    => 'Herr',
            'mobile_verified' => 1,
            'email_verified'=> 1
        ]);

        $account = Account::where('iban_owner', '=', 'Bonn John')->first();
        User::create([
            'account_id'    => $account['id'],
            'firstname'     => 'Jonny',
            'surname'       => 'SellerBonn',
            'email'         => 'seller-bonn@web.de',
            'mobile'        => '0123456789',
            'phone'         => '061235030',
            'fax'           => '061235030',
            'status'        => 'active',
            'password'      => Hash::make('dev'),
            'salutation'    => 'Herr',
            'mobile_verified' => 1,
            'email_verified'=> 1
        ]);

        $account = Account::where('iban_owner', '=', 'Nürnberg John')->first();
        User::create([
            'account_id'    => $account['id'],
            'firstname'     => 'Jonny',
            'surname'       => 'SellerNürnberg',
            'email'         => 'seller-nuernberg@web.de',
            'mobile'        => '0123456789',
            'phone'         => '061235030',
            'fax'           => '061235030',
            'status'        => 'active',
            'password'      => Hash::make('dev'),
            'salutation'    => 'Frau',
            'mobile_verified' => 1,
            'email_verified'=> 1
        ]);

        $account = Account::where('iban_owner', '=', 'München John')->first();
        User::create([
            'account_id'    => $account['id'],
            'firstname'     => 'Jonny',
            'surname'       => 'SellerMünchen',
            'email'         => 'seller-muenchen@web.de',
            'mobile'        => '0123456789',
            'phone'         => '061235030',
            'fax'           => '061235030',
            'status'        => 'active',
            'password'      => Hash::make('dev'),
            'salutation'    => 'Frau',
            'mobile_verified' => 1,
            'email_verified'=> 1
        ]);

        $account = Account::where('iban_owner', '=', 'Eltville John')->first();
        User::create([
            'account_id'    => $account['id'],
            'firstname'     => 'Jonny',
            'surname'       => 'SellerEltville',
            'email'         => 'seller-eltville@web.de',
            'mobile'        => '0123456789',
            'phone'         => '061235030',
            'fax'           => '061235030',
            'status'        => 'active',
            'password'      => Hash::make('dev'),
            'salutation'    => 'Frau',
            'mobile_verified' => 1,
            'email_verified'=> 1
        ]);

        $account = Account::where('iban_owner', '=', 'Mannheim John')->first();
        User::create([
            'account_id'    => $account['id'],
            'firstname'     => 'Jonny',
            'surname'       => 'SellerMannheim',
            'email'         => 'seller-mannheim@web.de',
            'mobile'        => '0123456789',
            'phone'         => '061235030',
            'fax'           => '061235030',
            'status'        => 'active',
            'password'      => Hash::make('dev'),
            'salutation'    => 'Herr',
            'mobile_verified' => 1,
            'email_verified'=> 1
        ]);

        $account = Account::where('iban_owner', '=', 'Stuttgart John')->first();
        User::create([
            'account_id'    => $account['id'],
            'firstname'     => 'Jonny',
            'surname'       => 'SellerStuttgart',
            'email'         => 'seller-stuttgart@web.de',
            'mobile'        => '0123456789',
            'phone'         => '061235030',
            'fax'           => '061235030',
            'status'        => 'active',
            'password'      => Hash::make('dev'),
            'salutation'    => 'Herr',
            'mobile_verified' => 1,
            'email_verified'=> 1
        ]);

        $account = Account::where('iban_owner', '=', 'Offenbach John')->first();
        User::create([
            'account_id'    => $account['id'],
            'firstname'     => 'Jonny',
            'surname'       => 'SellerOffenbach',
            'email'         => 'seller-offenbach@web.de',
            'mobile'        => '0123456789',
            'phone'         => '061235030',
            'fax'           => '061235030',
            'status'        => 'active',
            'password'      => Hash::make('dev'),
            'salutation'    => 'Herr',
            'mobile_verified' => 1,
            'email_verified'=> 1
        ]);

        $account = Account::where('iban_owner', '=', 'Hanau John')->first();
        User::create([
            'account_id'    => $account['id'],
            'firstname'     => 'Jonny',
            'surname'       => 'SellerHanau',
            'email'         => 'seller-hanau@web.de',
            'mobile'        => '0123456789',
            'phone'         => '061235030',
            'fax'           => '061235030',
            'status'        => 'active',
            'password'      => Hash::make('dev'),
            'salutation'    => 'Herr',
            'mobile_verified' => 1,
            'email_verified'=> 1
        ]);

        Model::unguard();
    }
}
