<?php

use App\Account;
use App\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UsersTableFakerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Model::unguard();

        $faker = Faker\Factory::create();

        for ($i = 20; $i <= 23; $i++) {
            User::create([
                'firstname'     => $faker->firstName,
                'surname'       => $faker->lastName,
                'email'         => $faker->email,
                'mobile'        => '',
                'phone'         => $faker->phoneNumber,
                'fax'           => '',
                'status'        => 'active',
                'password'      => Hash::make('dev'),
                'salutation'    => 'Herr',
                'account_id'    => $i,
                'email_verified'=> 1
            ]);
        }
    }
}
