<?php

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Seeder;

class RatingsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        Model::unguard();

        $faker = Faker\Factory::create();
        $coupons = \App\Coupon::all();
        foreach ($coupons as $coupon) {
            \App\Rating::create(array(
                'rating' => $faker->numberBetween(1, 5),
                'user_id' => $coupon->consumer_user_id,
                'rateable_id' => $coupon->id,
                'rateable_type' => \App\Coupon::class,
                'description' => 'Test Beschreibung',
                'rateable_user_type' => 'consumer',
                'rated_account_id' => $coupon->template->seller->account->id,
            ));
        }
    }
}
