<?php

use App\User;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class PermissionTableSeeder extends Seeder {
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run() {
        // FIXME: ausgliedern aus production seeder
        $users = User::all();
        foreach ( $users as $user ) {
            $roles = [ User::SELLER, User::AGENT, User::CONSUMER, User::FIELDSERVICE_EMPLOYEE ];
            $role  = $roles[array_rand( $roles, 1 )];

            if ( $user->email == 'operator@reco.ma' ) {
                $user->assignRole( User::OPERATOR );
                $user->givePermissionTo( 'edit account' );
                $user->givePermissionTo( 'edit account data' );
            } elseif ( $user->email == 'seller@reco.ma' ) {
                $user->assignRole( User::SELLER );
                $user->assignRole( 'seller-active' );
                $user->givePermissionTo( 'edit account' );
                $user->givePermissionTo( 'edit account data' );
            } elseif ( $user->email == 'seller_for_all@reco.ma' || $user->email == 'seller-bonn@web.de' || $user->email == 'seller-offenbach@web.de' ||
                $user->email =='seller-koblenz@web.de' || $user->email =='seller-hanau@web.de' || $user->email =='seller-stuttgart@web.de' ||
                $user->email =='seller-mannheim@web.de' || $user->email =='seller-eltville@web.de' || $user->email == 'seller-muenchen@web.de' ||
                $user->email == 'seller-neuwied@web.de' || $user->email == 'seller-ruedesheim@web.de' || $user->email == 'seller-koeln@web.de' ||
                $user->email == 'seller-nuernberg@web.de') {
                $user->assignRole( User::SELLER );
                $user->assignRole( 'seller-active' );
                $user->givePermissionTo( 'edit account' );
                $user->givePermissionTo( 'edit account data' );
            } elseif ( $user->email == 'agent@reco.ma' ) {
                $user->assignRole( User::AGENT );
                $user->givePermissionTo( 'edit account' );
            } elseif ( $user->email == 'consumer@reco.ma' ) {
                $user->assignRole( User::CONSUMER );
                $user->givePermissionTo( 'edit account' );
            } elseif ( $user->email == 'agent-consumer@reco.ma' ) {
                $user->assignRole( User::AGENT );
                $user->assignRole( 'consumer' );
                $user->givePermissionTo( 'edit account' );
            } elseif ( $user->email == 'fieldservice_employee@reco.ma' ) {
                $user->givePermissionTo( 'edit account' );
                $user->assignRole( User::FIELDSERVICE_EMPLOYEE );
                $user->assignRole( User::AGENT );
            } else {
                $user->assignRole( $role );
            }
        }
    }
}