<?php

use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    public function truncateAll()
    {
        if (App::environment() === 'production') die('not for production');

        Eloquent::unguard();

        DB::statement('SET FOREIGN_KEY_CHECKS = 0');

        // Truncate all tables, except migrations
        $tables = DB::select('SHOW TABLES');
        foreach ($tables as $table) {
            $tableName =  reset($table);
            if ($tableName !== 'migrations')
                DB::table($tableName)->truncate();
        }

        DB::statement('SET FOREIGN_KEY_CHECKS = 1');
    }
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // $this->truncateAll(); // we do not want to truncate all - geo data should stay, so temporarily deactivated
        // you might want to exclude the geo data

        //the portraits-Folder is gitignored, so after resetting the system and migrate:refresh there would be no company logo which can be referenced in the seeds
        $srcDefaultImage = "public/img/logo_company.png";
        $destDefaultImage = "storage/app/portraits/logo_company.png";
        copy($srcDefaultImage,$destDefaultImage);


        // $this->call(OpengeodbSeeder::class);  // removed for performance reasons
        $this->call(CategoriesSeeder::class);
        $this->call(AccountsTableSeeder::class);
        $this->call(UsersTableSeeder::class);
        $this->call(AccountsTableFakerSeeder::class);
        $this->call(UsersTableFakerSeeder::class);
        $this->call(PermissionTableSeeder::class);
        $this->call(AccountConnectionsTableSeeder::class);
        $this->call(CouponTemplatesTableSeeder::class);
        $this->call(InvitationsTableSeeder::class);
        $this->call(CouponTableSeeder::class);
        $this->call(TransactionTableSeeder::class);
        $this->call(RatingsTableSeeder::class);
        $this->call(AddRecommendRecomaToSellerAndAgentTableSeeder::class);
    }
}
