<?php

use App\CouponTemplate;
use App\User;
use Carbon\Carbon;
use Illuminate\Database\Seeder;

class CouponTemplatesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $seller = User::where('email', '=', 'seller@reco.ma')->first();
        CouponTemplate::create([
            'user_id' => $seller->id,
            'title' => 'Sparen',
            'expiration_date' => Carbon::now()->addMonth(),
            'description' => '-',
            'provision_agent' => '5',
            'discount_consumer' => '10',
            'quota' => '42',
            'status' => 'inactive',
            'validity' => '5'

        ]);

        CouponTemplate::create([
            'user_id' => $seller->id,
            'title' => '15% auf die erste Bestellung',
            'expiration_date' => Carbon::now()->addMonth(),
            'description' => '-',
            'provision_agent' => '5',
            'discount_consumer' => '15',
            'quota' => '250',
            'status' => 'active',
            'validity' => '5'

        ]);

        CouponTemplate::create([
            'user_id' => $seller->id,
            'title' => '16% auf die erste Bestellung',
            'expiration_date' => Carbon::now()->addMonth(),
            'description' => '-',
            'provision_agent' => '5',
            'discount_consumer' => '16',
            'quota' => '250',
            'status' => 'active',
            'validity' => '5'

        ]);

        $seller2 = User::where('email', '=', 'seller_for_all@reco.ma')->first();

        CouponTemplate::create([
            'user_id' => $seller2->id,
            'title' => '15% alle Bestellungen',
            'expiration_date' => Carbon::now()->addMonth(),
            'description' => '-',
            'provision_agent' => '5',
            'discount_consumer' => '15',
            'quota' => '250',
            'status' => 'active',
            'validity' => '5'

        ]);
    }
}
