<?php

use App\Coupon;
use App\User;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Seeder;

class CouponTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Model::unguard();

        $faker = Faker\Factory::create();

        Coupon::create([
            'coupon_template_id' => '1',
            'consumer_user_id' => User::where('email', '=', 'consumer@reco.ma')->first()->id,
            'agent_user_id' => User::where('email', '=', 'agent@reco.ma')->first()->id,
            'title' => 'Sparen 2',
            'expiration_date' => Carbon::now()->addMonth(),
            'description' => $faker->paragraph(rand(1, 10)),
            'provision_agent' => '5',
            'discount_consumer' => '10',
            'status' => 'active',
            'code' => 'ASDF1234J',
            'netto' => '0.00'
        ]);

        $coupon = Coupon::create([
            'coupon_template_id' => '1',
            'consumer_user_id' => User::where('email', '=', 'consumer@reco.ma')->first()->id,
            'agent_user_id' => User::where('email', '=', 'agent@reco.ma')->first()->id,
            'title' => 'Sparen 3',
            'expiration_date' =>  Carbon::now()->addMonth(),
            'description' => $faker->paragraph(rand(1, 10)),
            'provision_agent' => '5',
            'discount_consumer' => '10',
            'status' => 'active',
            'code' => 'A80JDSUW9',
            'netto' => '0.00'
        ]);

        $coupon->redeem('100','119');

        Coupon::create([
            'coupon_template_id' => '1',
            'consumer_user_id' => User::where('email', '=', 'consumer@reco.ma')->first()->id,
            'agent_user_id' => User::where('email', '=', 'agent@reco.ma')->first()->id,
            'title' => 'Sparen 4',
            'expiration_date' =>  Carbon::now()->addMonth(),
            'description' => $faker->paragraph(rand(1, 10)),
            'provision_agent' => '5',
            'discount_consumer' => '10',
            'status' => 'pending',
            'code' => 'JD7a8OXju',
            'netto' => '0.00'
        ]);

        Coupon::create([
            'coupon_template_id' => '1',
            'consumer_user_id' => User::where('email', '=', 'consumer@reco.ma')->first()->id,
            'agent_user_id' => User::where('email', '=', 'agent@reco.ma')->first()->id,
            'title' => 'Sparen 5',
            'expiration_date' =>  Carbon::now()->addMonth(),
            'description' => $faker->paragraph(rand(1, 10)),
            'provision_agent' => '5',
            'discount_consumer' => '10',
            'status' => 'redeemed',
            'code' => 'JD7l89Xjb',
            'netto' => '0.00'
        ]);

        Coupon::create([
            'coupon_template_id' => '1',
            'consumer_user_id' => User::where('email', '=', 'agent-consumer@reco.ma')->first()->id,
            'agent_user_id' => User::where('email', '=', 'agent@reco.ma')->first()->id,
            'title' => 'Sparen 10',
            'expiration_date' =>  Carbon::now()->addMonth(),
            'description' => $faker->paragraph(rand(1, 10)),
            'provision_agent' => '9',
            'discount_consumer' => '17',
            'status' => 'active',
            'code' => 'JQ1a3OJjC',
            'netto' => '0.00'
        ]);

        Coupon::create([
            'coupon_template_id' => '1',
            'consumer_user_id' => User::where('email', '=', 'agent-consumer@reco.ma')->first()->id,
            'agent_user_id' => User::where('email', '=', 'agent@reco.ma')->first()->id,
            'title' => 'Sparen 11',
            'expiration_date' =>  Carbon::now()->addMonth(),
            'description' => $faker->paragraph(rand(1, 10)),
            'provision_agent' => '7',
            'discount_consumer' => '25',
            'status' => 'redeemed',
            'code' => 'JD7l89XjR',
            'netto' => '0.00'
        ]);

        Coupon::create([
            'coupon_template_id' => '1',
            'consumer_user_id' => User::where('email', '=', 'consumer@reco.ma')->first()->id,
            'agent_user_id' => User::where('email', '=', 'agent@reco.ma')->first()->id,
            'title' => 'Sparen 6',
            'expiration_date' =>  Carbon::now()->addMonth(),
            'description' => $faker->paragraph(rand(1, 10)),
            'provision_agent' => '5',
            'discount_consumer' => '10',
            'status' => 'active',
            'code' => 'JQ1a3OJjl',
            'netto' => '0.00'
        ]);
    }
}
