<?php

use Illuminate\Database\Seeder;
use App\Category;

class CategoriesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $categories = [
            ['name' => 'Haushalt', 'children' => [
                ['name' => 'Inneneinrichtung', 'children' => [
                    ['name' => 'Betten und Matratzen'],
                    ['name' => 'Möbel und Wohnen'],
                    ['name' => 'Raumausstatter'],
                    ['name' => 'Sanitär, Badstudio'],
                    ['name' => 'Laminat, Parkett, Estrich, Teppich'],
                    ['name' => 'Tapeten'],
                    ['name' => 'Treppen'],
                    ['name' => 'Türen'],
                    ['name' => 'Fensterbau, Rollos, Markisen'],
                    ['name' => 'Haushalt und Küche, Küchenstudio'],
                    ['name' => 'Kaminbauer'],
                    ['name' => 'Büroausstattung'],
                    ['name' => 'Fliesenfachhandel'],
                    ['name' => 'Handwerker'],
                    ['name' => 'Tischler'],
                    ['name' => 'Gas und Strom dienstleister'],
                    ['name' => 'Fliesenleger'],
                ]],
                ['name' => 'Versorgungsleitung', 'children' => [
                    ['name' => 'Elektrofachhandel'],
                    ['name' => 'Elektroinstallationen'],
                    ['name' => 'Gas- Wasser- Heizungsinstallateur'],
                    ['name' => 'Kälte und Klimatechnik, Klimaanlage, Heizung'],
                ]],
                ['name' => 'Aussenarbeiten', 'children' => [
                    ['name' => 'Stuck'],
                    ['name' => 'Dachdecker'],
                    ['name' => 'Gartenbau'],
                    ['name' => 'Zaunbau'],
                ]],
                ['name' => 'Dienstleistung', 'children' => [
                    ['name' => 'Umzug'],
                    ['name' => 'Umzugsunternehmen'],
                    ['name' => 'Gebäudereinigung'],
                    ['name' => 'Reinigung'],
                    ['name' => 'Entsorgung'],
                ]],
            ]],
            ['name' => 'Bautechnik & Bauarbeiten', 'children' => [
                ['name' => 'Bauarbeiten'],
                ['name' => 'Abrissunternehmen'],
                ['name' => 'Aufzug und Liftsysteme'],
                ['name' => 'Bauunternehmen'],
                ['name' => 'Generalunternehmen'],
                ['name' => 'Gerüstbau'],
                ['name' => 'Hausbaufirma'],
                ['name' => 'Hausmeisterservice'],
                ['name' => 'Maschinenbauer'],
                ['name' => 'Maurer'],
                ['name' => 'Metallbau'],
                ['name' => 'Natursteinhandel'],
                ['name' => 'Reinigung'],
                ['name' => 'Stahlbau'],
                ['name' => 'Stahlhandel'],
                ['name' => 'Straßenbauer'],
                ['name' => 'Tiefbau'],
                ['name' => 'Transport'],
                ['name' => 'Trockenbau'],
                ['name' => 'Zimmermann'],
                ['name' => 'Klempner'],
                ['name' => 'Maler und Lackierer'],
                ['name' => 'Baugutachter'],
                ['name' => 'Bauingenieur'],
                ['name' => 'Baumaschinenhandel'],
                ['name' => 'Baufachhandel'],
                ['name' => 'Baumarkt'],
                ['name' => 'Solartechnik'],
                ['name' => 'Nutzmaschinen'],
                ['name' => 'Gebäudereinigung'],
                ['name' => 'Reinigung'],
                ['name' => 'Entsorgung'],
            ]],
            ['name' => 'Auto', 'children' => [
                ['name' => 'Wohnmobile'],
                ['name' => 'Auto und Mobilität'],
                ['name' => 'Autohandel'],
                ['name' => 'Autolackiererei'],
                ['name' => 'Autoteile'],
                ['name' => 'Autowerkstatt'],
                ['name' => 'LKW Handel'],
                ['name' => 'Motorradhandel'],
                ['name' => 'Motorradteile'],
                ['name' => 'Reifen'],
                ['name' => 'LKW Werkstatt'],
                ['name' => 'Autovermietung'],
                ['name' => 'Fahrradgeschäft'],
            ]],
            ['name' => 'Schönheit & Gesundheit', 'children' => [
                ['name' => 'Apotheken und Drogerien'],
                ['name' => 'Brillen und Kontaktlinsen'],
                ['name' => 'Friseur'],
                ['name' => 'Kosmetikstudio'],
                ['name' => 'Naturheilpraxis'],
                ['name' => 'Orthopädie'],
                ['name' => 'Parfum und Kosmetik'],
                ['name' => 'Schmuck und Uhren'],
                ['name' => 'Schönheitsklinik'],
                ['name' => 'Stylist'],
                ['name' => 'Fitnessstudio'],
                ['name' => 'Gesundheitsberatung'],
                ['name' => 'Personal Trainer'],
                ['name' => 'Pflegedienst'],
                ['name' => 'Physiotherapeut'],
                ['name' => 'Psychologe'],
                ['name' => 'Psychotherapeut'],
                ['name' => 'Ernährungsberatung'],
                ['name' => 'Spa, Wellness und Massage'],
                ['name' => 'Sanitätshaus'],
            ]],
            ['name' => 'Freizeit', 'children' => [
                ['name' => 'Hochzeit', 'children' => [
                    ['name' => 'Hochzeitsräumlichkeit'],
                    ['name' => 'Hochzeitsservice'],
                    ['name' => 'Braut und Hochzeitmode'],
                ]],
                ['name' => 'Freizeit', 'children' => [
                    ['name' => 'Partyservice und Catering'],
                    ['name' => 'Bowling'],
                    ['name' => 'Discothek'],
                    ['name' => 'Eintrittskarten und Tickets'],
                    ['name' => 'Flüge'],
                    ['name' => 'Freizeitpark'],
                    ['name' => 'Gokart'],
                    ['name' => 'Golfplatz'],
                    ['name' => 'Indoorspielplatz'],
                    ['name' => 'Kinder Freizeitpark'],
                    ['name' => 'Kino'],
                    ['name' => 'Kletterpark'],
                    ['name' => 'Lasertag'],
                    ['name' => 'Minigolf'],
                    ['name' => 'Museum'],
                    ['name' => 'Paintball'],
                    ['name' => 'Segway Verleih'],
                    ['name' => 'Sehenswürdigkeiten'],
                    ['name' => 'Wildpark'],
                    ['name' => 'Zoo'],
                    ['name' => 'Eventagentur'],
                    ['name' => 'Erlebnisbad'],
                    ['name' => 'Schwimmbad'],
                ]],
            ]],
            ['name' => 'Bildung', 'children' => [
                ['name' => 'Bildung'],
                ['name' => 'Sprachschule'],
                ['name' => 'Bücher und E-Books'],
                ['name' => 'Buchhandlung'],
            ]],
            ['name' => 'Essen und Trinken', 'children' => [
                ['name' => 'Bäcker'],
                ['name' => 'Restaurant, Cafe, Bars'],
                ['name' => 'Lieferservice'],
                ['name' => 'Food Truck'],
            ]],
            ['name' => 'Dienstleistung', 'children' => [
                ['name' => 'Design', 'children' => [
                    ['name' => 'Grafikdesign'],
                    ['name' => 'Webdesign'],
                    ['name' => 'Interior Design'],
                ]],
                ['name' => 'Immobilien', 'children' => [
                    ['name' => 'Immobilienagentur'],
                    ['name' => 'Immobiliengutachter'],
                    ['name' => 'Immobilienmakler'],
                    ['name' => 'Wohnungsbaugesellschaft'],
                ]],
                ['name' => 'Architektur', 'children' => [
                    ['name' => 'Ingenieur'],
                    ['name' => 'Innenarchitekt'],
                ]],
                ['name' => 'Medien', 'children' => [
                    ['name' => 'Medienunternehmen'],
                    ['name' => 'PR Agentur'],
                    ['name' => 'Werbeagentur'],
                    ['name' => 'Verschiedenes'],
                    ['name' => 'Optiker'],
                    ['name' => 'Privatdetektiv'],
                    ['name' => 'Statiker'],
                    ['name' => 'Kurierdienst'],
                    ['name' => 'Unternehmensberatung'],
                    ['name' => 'Vermietung'],
                    ['name' => 'Vertrieb'],
                    ['name' => 'Call Center'],
                    ['name' => 'Copyshop und Druckerei'],
                    ['name' => 'Coworking Space'],
                    ['name' => 'Arbeitsvermittlung'],
                    ['name' => 'Auktionen'],
                    ['name' => 'Auktionen'],
                ]],
            ]],
            ['name' => 'Reisen und Urlaub', 'children' => [
                ['name' => 'Hotels und Apartments'],
                ['name' => 'Reisebüro'],
                ['name' => 'Reisen und Urlaub'],
                ['name' => 'Schiffs- und Bootsfahrten'],
                ['name' => 'Kreuzfahrten'],
                ['name' => 'Reisetickets'],
            ]],
            ['name' => 'Kids', 'children' => [
                ['name' => 'Kinder und Babyausstattung'],
                ['name' => 'Spielzeug'],
                ['name' => 'Kinder und Babybekleidung'],
            ]],
            ['name' => 'Fashion', 'children' => [
                ['name' => 'Accessoires'],
                ['name' => 'Boutique'],
                ['name' => 'Braut und Hochzeitmode'],
                ['name' => 'Dessous'],
                ['name' => 'Kinder und Babybekleidung'],
                ['name' => 'Mode und Bekleidung'],
                ['name' => 'Schmuckfachhandel'],
                ['name' => 'Schneider - Änderungsschneider'],
                ['name' => 'Schuhe'],
                ['name' => 'Sport und Outdoor'],
                ['name' => 'Streetwear'],
                ['name' => 'Taschen und Koffer'],
            ]],
            ['name' => 'Computer und Software', 'children' => [
                ['name' => 'Computerservice'],
                ['name' => 'Domains und Hosting'],
                ['name' => 'Druck und Fotodienste'],
                ['name' => 'Elektro und Multimedia'],
                ['name' => 'Notebooks und PCs'],
                ['name' => 'Programmierer'],
                ['name' => 'Software'],
                ['name' => 'Softwareentwicklung'],
                ['name' => 'Softwarevertrieb'],
            ]],
            ['name' => 'Geschenke', 'children' => [
                ['name' => 'Blumen'],
                ['name' => 'Deko und Lifestyle'],
                ['name' => 'Erlebnisgeschenke'],
                ['name' => 'Geschenke'],
                ['name' => 'Geschenkgutscheine'],
                ['name' => 'Gesundheit und Wellness'],
                ['name' => 'Lotto und Gewinnspiele'],
            ]],
            ['name' => 'Haustiere', 'children' => [
                ['name' => 'Aquaristik'],
                ['name' => 'Tierbedarf'],
            ]],
            ['name' => 'Internet, Mobile, TV', 'children' => [
                ['name' => 'Internet, Festnetz und TV'],
                ['name' => 'Medien und Unterhaltung'],
                ['name' => 'Mobilfunk'],
            ]],
            ['name' => 'Verschiedenes', 'children' => [
                ['name' => 'Partnerbörsen und Erotik'],
                ['name' => 'Zeitschriften und Abos'],
            ]],
            ['name' => 'Finanz und Beratung', 'children' => [
                ['name' => 'Beratung'],
                ['name' => 'Rechtsanwalt'],
                ['name' => 'Buchhaltung'],
                ['name' => 'Unternehmensberatung'],
                ['name' => 'Finanzberater'],
                ['name' => 'Bank und Kreditinstitut'],
                ['name' => 'Kredite'],
                ['name' => 'Börsenmakler'],
                ['name' => 'Versicherungen'],
                ['name' => 'Leasing'],
                ['name' => 'Steuerberater'],
            ]],
        ];

        Category::buildTree($categories);
    }
}
