<?php

use App\Account;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Seeder;

class AccountsTableFakerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Model::unguard();

        $faker = Faker\Factory::create();
        $city = array(20 => 'Mannheim', 'Willich',  'Rastatt', 'Hürth');
        $zip = array(20 =>'68161','47877','76437','50354');

        for ($i = 20; $i <= 23; $i++) {
            Account::create([
                'iban'          => 'DE12500105170648489890',
                'iban_owner'    => $faker->firstName . ' ' . $faker->lastName,
                'company'       => $faker->company,
                'street'        => $faker->streetName,
                'housenumber'   => '3',
                'zip'           => $zip[$i],
                'city'          => $city[$i],
                'tax_id'        => '123456789',
                'payment'       => 'year',
                'status'        => 'active',
                'upload_portrait'   => '',
                'description'   => 'Account Beschreibung'
            ]);
        }
    }
}
