<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddTfaToUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('tfa_code')->nullable();
            $table->dateTime('tfa_code_expires_at')->nullable();
            $table->string('google_tfa_secret')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('tfa_code');
            $table->dropColumn('tfa_code_expires_at');
            $table->dropColumn('google_tfa_secret');
        });
    }
}
