<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUserLogTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_log_actions', function (Blueprint $table) {
            $table->increments('id');
            $table->string('action');
        });

        Schema::create('user_log_useragents', function (Blueprint $table) {
            $table->increments('id');
            $table->text('useragent');
        });

        Schema::create('user_log', function (Blueprint $table) {
            $table->increments('id');

            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users');

            $table->integer('action_id')->unsigned();
            $table->foreign('action_id')->references('id')->on('user_log_actions');

            $table->json('changes')->nullable();
            $table->string('model', 50)->nullable();
            $table->integer('model_id')->unsigned()->nullable();
            $table->string('ip_address', 50);

            $table->integer('useragent_id')->unsigned();
            $table->foreign('useragent_id')->references('id')->on('user_log_useragent');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('user_log_actions');
        Schema::drop('user_log_useragents');
        Schema::drop('user_log');
    }
}
