<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGeoAddressesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('geo_adresses', function(Blueprint $table) {
            $table->increments('id');

            $table->string('hash')->unique();

            $table->string('street');
            $table->string('housenumber');
            $table->string('zip');
            $table->string('city');

            $table->float('lat', 12, 8);
            $table->float('lon', 12, 8);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('geo_adresses');
    }
}
