<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePlacesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('places', function(Blueprint $table) {
            $table->increments('id');
            $table->integer('seller_id')->unsigned();
            $table->foreign('seller_id')->references('id')->on('users');

            // address, contacts
            $table->string('street')->nullable();
            $table->string('housenumber')->nullable();
            $table->string('zip')->nullable();
            $table->string('city')->nullable();
            $table->string('phone')->nullable();
            $table->string('email')->nullable();
            $table->float('lat', 12, 8)->nullable();
            $table->float('lon', 12, 8)->nullable();

            // working times
            $table->string('wt_mon')->nullable();
            $table->string('wt_tue')->nullable();
            $table->string('wt_wed')->nullable();
            $table->string('wt_thu')->nullable();
            $table->string('wt_fri')->nullable();
            $table->string('wt_sat')->nullable();
            $table->string('wt_sun')->nullable();

            $table->string('status')->default('active');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('places');
    }
}
