<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddPaymentTypeToCreditNotesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('credit_notes', function (Blueprint $table) {
            $table->string('payment_type')->nullable()->default('bank');
            $table->string('paypal_payer_id')->nullable()->default(NULL);
            $table->json('paypal_payload')->nullable()->default(null);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('credit_notes', function (Blueprint $table) {
            $table->dropColumn('payment_type');
            $table->dropColumn('paypal_payer_id');
            $table->dropColumn('paypal_payload');
        });
    }
}
