<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class CreateUsersGiftsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users_gifts', function(Blueprint $table) {
            $table->increments('id');

            $table->integer('gift_id')->unsigned()->nullable();
            $table->foreign('gift_id')->references('id')->on('gifts');

            $table->integer('user_id')->unsigned()->nullable();
            $table->foreign('user_id')->references('id')->on('users');

            $table->integer('coupon_id')->unsigned()->nullable();
            $table->foreign('coupon_id')->references('id')->on('coupons');

            $table->string('address_plz', 5);
            $table->string('address_ort', 50);
            $table->string('address_str', 50);
            $table->string('address_num', 10);
            $table->string('address_add', 255);

            $table->string('status', 10)->nullable(false)->default('new');

            $table->timestamp('status_new_at')->nullable();
            $table->timestamp('status_paid_at')->nullable();
            $table->timestamp('status_ready_at')->nullable();
            $table->timestamp('status_sent_at')->nullable();
            $table->timestamp('status_received_at')->nullable();

            $table->timestamps();
        });

        // permissions to manage new entity
        Permission::create(['name' => 'show users gifts']);
        Permission::create(['name' => 'show own gifts']);
        Permission::create(['name' => 'create users gifts']);
        Permission::create(['name' => 'edit users gifts']);
        Permission::create(['name' => 'delete users gifts']);

        // attach permissions to operator
        $role = Role::findByName('operator');
        $role->givePermissionTo('show users gifts');
        $role->givePermissionTo('create users gifts');
        $role->givePermissionTo('edit users gifts');
        $role->givePermissionTo('delete users gifts');

        // attach permissions to user
        $role = Role::findByName('agent');
        $role->givePermissionTo('show own gifts');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('users_gifts');
    }
}
