<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class MakeDiscountAndProvisionFloat extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('coupon_templates', function (Blueprint $table) {
            $table->float('provision_agent', 2)->change();
            $table->float('discount_consumer', 2)->change();
        });

        Schema::table('coupons', function (Blueprint $table) {
            $table->float('provision_agent', 2)->change();
            $table->float('discount_consumer', 2)->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('coupon_templates', function (Blueprint $table) {
            $table->int('provision_agent')->change();
            $table->int('discount_consumer')->change();
        });

        Schema::table('coupons', function (Blueprint $table) {
            $table->int('provision_agent')->change();
            $table->int('discount_consumer')->change();
        });
    }
}
