<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddTypesToCouponTemplatesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('coupon_templates', function (Blueprint $table) {
            $table->renameColumn('type', 'type_provision');
            $table->string('type_discount', 10)->nullable(false)->default('percent');
            $table->integer('provision_gift_id')->unsigned()->nullable();
            $table->foreign('provision_gift_id')->references('id')->on('gifts');
            $table->integer('discount_gift_id')->unsigned()->nullable();
            $table->foreign('discount_gift_id')->references('id')->on('gifts');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('coupon_templates', function (Blueprint $table) {
            $table->renameColumn('type_provision', 'type');
            $table->dropColumn('type_discount');
            $table->dropColumn('provision_gift_id');
            $table->dropForeign('gifts_provision_gift_id_foreign');
            $table->dropColumn('discount_gift_id');
            $table->dropForeign('gifts_discount_gift_id_foreign');
        });
    }
}
