<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class CreateGiftsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('gifts', function(Blueprint $table) {
            $table->increments('id');

            $table->string('name', 255);
            $table->decimal('price', 25, 2);
            $table->string('image', 255)->nullable();
            $table->boolean('active');
            $table->text('description');

            $table->timestamps();
        });

        // permissions to manage new entity
        Permission::create(['name' => 'show gifts']);
        Permission::create(['name' => 'create gifts']);
        Permission::create(['name' => 'edit gifts']);
        Permission::create(['name' => 'delete gifts']);

        // attach permissions to operator
        $role = Role::findByName('operator');
        $role->givePermissionTo('show gifts');
        $role->givePermissionTo('create gifts');
        $role->givePermissionTo('edit gifts');
        $role->givePermissionTo('delete gifts');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('gifts');
    }
}
