<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class CreateCategoriesTable extends Migration {
    /**
    * Run the migrations.
    *
    * @return void
    */
    public function up() {
        Schema::create('categories', function(Blueprint $table) {
            $table->increments('id');
            $table->integer('parent_id')->nullable()->index();
            $table->integer('lft')->nullable()->index();
            $table->integer('rgt')->nullable()->index();
            $table->integer('depth')->nullable();

            $table->string('name', 255);
            $table->string('icon', 255)->nullable();

            $table->timestamps();
        });

        // permissions to manage new entity
        Permission::create(['name' => 'show categories']);
        Permission::create(['name' => 'create categories']);
        Permission::create(['name' => 'edit categories']);
        Permission::create(['name' => 'delete categories']);

        // attach permissions to operator
        $role = Role::findByName('operator');
        $role->givePermissionTo('show categories');
        $role->givePermissionTo('create categories');
        $role->givePermissionTo('edit categories');
        $role->givePermissionTo('delete categories');
    }

    /**
    * Reverse the migrations.
    *
    * @return void
    */
    public function down() {
        Schema::drop('categories');
    }
}
