<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddRecruitedAccountIdToTransactions extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('transactions', function (Blueprint $table) {
            $table->integer('recruited_account_id')->unsigned()->after('coupon_id')->index()->nullable();
            $table->foreign('recruited_account_id')->references('id')->on('accounts')->onDelete('set null');
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('transactions', function (Blueprint $table) {
            $table->dropForeign('transactions_recruited_account_id_foreign');
            $table->dropColumn('recruited_account_id');
        });
    }
}
