<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class RecruiterUserIdToAccountsAndRemoveLinkinvitationReference extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('accounts', function (Blueprint $table) {
            $table->integer('recruiter_user_id')->unsigned()->index()->nullable();
            $table->foreign('recruiter_user_id')->references('id')->on('users')->onDelete('set null');
        });

        Schema::table('accounts', function (Blueprint $table) {
            $table->dropForeign('accounts_linkinvitation_id_foreign');
            $table->dropColumn('linkinvitation_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('accounts', function (Blueprint $table) {
            $table->dropForeign('accounts_recruiter_user_id_foreign');
            $table->dropColumn('recruiter_user_id');
        });

        Schema::table('accounts', function (Blueprint $table) {
            $table->integer('linkinvitation_id')->unsigned()->index()->nullable();
            $table->foreign('linkinvitation_id')->references('id')->on('link_invitations')->onDelete('cascade');
        });
    }
}
