<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Spatie\Permission\Models\Role;

class AddAdmRoleWithPermissions extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        \Spatie\Permission\Models\Permission::create(['name' => 'show fieldservice transactions']);
        \Spatie\Permission\Models\Permission::create(['name' => 'show recruited users']);
        \Spatie\Permission\Models\Permission::create(['name' => 'edit new recruited users']);
        \Spatie\Permission\Models\Permission::create(['name' => 'create recruited users']);

        //Außendienstmitarbeiter / adm
        $role = Role::create(['name' => 'fieldservice_employee']);
        $role->givePermissionTo('create recruited users');
        $role->givePermissionTo('show recruited users');
        $role->givePermissionTo('edit new recruited users');
        $role->givePermissionTo('show user profile');
        $role->givePermissionTo('filter dashboard');
        $role->givePermissionTo('show invitation');
        $role->givePermissionTo('show fieldservice transactions');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
