<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddArrowChatTablesWithData extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $sql = <<<'SQL'
CREATE TABLE `arrowchat` (
  `id` int(10) UNSIGNED NOT NULL,
  `from` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `to` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `sent` int(10) UNSIGNED NOT NULL,
  `read` int(10) UNSIGNED NOT NULL,
  `user_read` tinyint(1) NOT NULL DEFAULT '0',
  `direction` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `arrowchat_admin`
--

CREATE TABLE `arrowchat_admin` (
  `id` int(3) UNSIGNED NOT NULL,
  `username` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Daten für Tabelle `arrowchat_admin`
--

INSERT INTO `arrowchat_admin` (`id`, `username`, `password`, `email`) VALUES
(1, 'admin', '873399b30c2844f48e68ed452f8230ec', 'dev@example.de');

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `arrowchat_applications`
--

CREATE TABLE `arrowchat_applications` (
  `id` int(3) UNSIGNED NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `folder` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `width` int(4) UNSIGNED NOT NULL,
  `height` int(4) UNSIGNED NOT NULL,
  `bar_width` int(3) UNSIGNED DEFAULT NULL,
  `bar_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dont_reload` tinyint(1) UNSIGNED DEFAULT '0',
  `default_bookmark` tinyint(1) UNSIGNED DEFAULT '1',
  `show_to_guests` tinyint(1) UNSIGNED DEFAULT '1',
  `link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `update_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `version` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `active` tinyint(1) UNSIGNED NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `arrowchat_banlist`
--

CREATE TABLE `arrowchat_banlist` (
  `ban_id` int(10) UNSIGNED NOT NULL,
  `ban_userid` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ban_ip` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `banned_by` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `banned_time` int(20) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `arrowchat_chatroom_banlist`
--

CREATE TABLE `arrowchat_chatroom_banlist` (
  `id` int(10) UNSIGNED NOT NULL,
  `user_id` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `chatroom_id` int(10) UNSIGNED NOT NULL,
  `ban_length` int(10) UNSIGNED NOT NULL,
  `ban_time` int(10) UNSIGNED NOT NULL,
  `ip_address` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `arrowchat_chatroom_messages`
--

CREATE TABLE `arrowchat_chatroom_messages` (
  `id` int(10) UNSIGNED NOT NULL,
  `chatroom_id` int(10) UNSIGNED NOT NULL,
  `user_id` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `username` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `global_message` tinyint(1) UNSIGNED DEFAULT '0',
  `is_mod` tinyint(1) UNSIGNED DEFAULT '0',
  `is_admin` tinyint(1) UNSIGNED DEFAULT '0',
  `sent` int(10) UNSIGNED NOT NULL,
  `action` tinyint(1) UNSIGNED DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `arrowchat_chatroom_rooms`
--

CREATE TABLE `arrowchat_chatroom_rooms` (
  `id` int(10) UNSIGNED NOT NULL,
  `author_id` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `welcome_message` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `image` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` tinyint(1) UNSIGNED NOT NULL,
  `password` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `length` int(10) UNSIGNED NOT NULL,
  `is_featured` tinyint(1) UNSIGNED DEFAULT NULL,
  `max_users` int(10) NOT NULL DEFAULT '0',
  `limit_message_num` int(5) NOT NULL DEFAULT '3',
  `limit_seconds_num` int(5) NOT NULL DEFAULT '10',
  `disallowed_groups` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_time` int(10) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `arrowchat_chatroom_users`
--

CREATE TABLE `arrowchat_chatroom_users` (
  `user_id` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `chatroom_id` int(10) UNSIGNED NOT NULL,
  `is_admin` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `is_mod` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `block_chats` tinyint(4) UNSIGNED NOT NULL DEFAULT '0',
  `silence_length` int(3) UNSIGNED DEFAULT NULL,
  `silence_time` int(15) UNSIGNED DEFAULT NULL,
  `session_time` int(15) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `arrowchat_config`
--

CREATE TABLE `arrowchat_config` (
  `config_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `config_value` text COLLATE utf8mb4_unicode_ci,
  `is_dynamic` tinyint(1) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Daten für Tabelle `arrowchat_config`
--

INSERT INTO `arrowchat_config` (`config_name`, `config_value`, `is_dynamic`) VALUES
('admin_background_color', '', 0),
('admin_chat_all', '0', 0),
('admin_text_color', '', 0),
('admin_view_maintenance', '0', 0),
('announcement', '', 0),
('applications_guests', '1', 0),
('applications_on', '0', 0),
('auto_popup_chatbox', '1', 0),
('bar_fixed', '0', 0),
('bar_fixed_alignment', 'center', 0),
('bar_fixed_width', '900', 0),
('bar_padding', '15', 0),
('base_url', '/arrowchat/', 0),
('blocked_words', 'fuck,[shit],nigger,[cunt],[ass],asshole', 0),
('buddy_list_heart_beat', '60', 0),
('chat_maintenance', '0', 0),
('chatroom_auto_join', '0', 0),
('chatroom_default_names', '0', 0),
('chatroom_history_length', '60', 0),
('chatroom_message_length', '150', 0),
('chatroom_transfer_on', '0', 0),
('chatrooms_on', '0', 0),
('desktop_notifications', '0', 0),
('disable_arrowchat', '0', 0),
('disable_avatars', '0', 0),
('disable_buddy_list', '0', 0),
('disable_smilies', '0', 0),
('enable_chat_animations', '1', 0),
('enable_mobile', '0', 0),
('enable_moderation', '0', 0),
('facebook_app_id', '', 0),
('file_transfer_on', '0', 0),
('giphy_chatroom_off', '0', 0),
('giphy_off', '0', 0),
('group_disable_apps', '', 0),
('group_disable_arrowchat', '', 0),
('group_disable_rooms', '', 0),
('group_disable_sending_private', '', 0),
('group_disable_sending_rooms', '', 0),
('group_disable_uploads', '', 0),
('group_disable_video', '', 0),
('group_enable_mode', '0', 0),
('guest_name_bad_words', 'fuck,cunt,nigger,shit,admin,administrator,mod,moderator,support', 0),
('guest_name_change', '1', 0),
('guest_name_duplicates', '0', 0),
('guests_can_chat', '0', 0),
('guests_can_view', '0', 0),
('guests_chat_with', '1', 0),
('heart_beat', '3', 0),
('hide_admins_buddylist', '0', 0),
('hide_applications_menu', '0', 0),
('hide_bar_on', '1', 0),
('idle_time', '3', 0),
('install_time', '1503325298', 0),
('language', 'en', 0),
('login_url', '', 0),
('max_upload_size', '5', 0),
('notifications_on', '0', 0),
('online_list_on', '1', 0),
('online_timeout', '120', 0),
('popout_chat_on', '1', 0),
('push_on', '0', 0),
('push_publish', '', 0),
('push_ssl', '0', 0),
('push_subscribe', '', 0),
('search_number', '10', 0),
('show_bar_links_right', '0', 0),
('show_full_username', '0', 0),
('theme', 'new_facebook_full', 0),
('theme_change_on', '0', 0),
('tokbox_api', '', 0),
('tokbox_secret', '', 0),
('us_time', '1', 0),
('user_chatrooms', '0', 0),
('user_chatrooms_flood', '10', 0),
('user_chatrooms_length', '30', 0),
('users_chat_with', '3', 0),
('video_chat', '1', 0),
('video_chat_height', '600', 0),
('video_chat_selection', '1', 0),
('video_chat_width', '900', 0),
('width_applications', '16', 0),
('width_buddy_list', '189', 0),
('width_chatrooms', '16', 0),
('window_top_padding', '70', 0);

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `arrowchat_graph_log`
--

CREATE TABLE `arrowchat_graph_log` (
  `id` int(6) UNSIGNED NOT NULL,
  `date` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_messages` int(10) UNSIGNED DEFAULT '0',
  `chat_room_messages` int(10) UNSIGNED DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `arrowchat_notifications`
--

CREATE TABLE `arrowchat_notifications` (
  `id` int(25) UNSIGNED NOT NULL,
  `to_id` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author_id` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `misc1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `misc2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `misc3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` int(3) UNSIGNED NOT NULL,
  `alert_read` int(1) UNSIGNED NOT NULL DEFAULT '0',
  `user_read` int(1) UNSIGNED NOT NULL DEFAULT '0',
  `alert_time` int(15) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `arrowchat_notifications_markup`
--

CREATE TABLE `arrowchat_notifications_markup` (
  `id` int(10) UNSIGNED NOT NULL,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` int(3) UNSIGNED NOT NULL,
  `markup` text COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Daten für Tabelle `arrowchat_notifications_markup`
--

INSERT INTO `arrowchat_notifications_markup` (`id`, `name`, `type`, `markup`) VALUES
(1, 'Private Messages', 1, '<div class="arrowchat_notification_box arrowchat_blue_link"><img src="/arrowchat/themes/new_facebook_full/images/icons/notification_message_icon.png" class="arrowchat_notification_icon" /><a href="#">{author_name}</a> has sent you a new message.<br /><div class="arrowchat_received">Received {longago}</div></div><div class="arrowchat_notifications_divider"></div>'),
(2, 'Friend Requests', 2, '<div class="arrowchat_notification_box arrowchat_blue_link"><img src="/arrowchat/themes/new_facebook_full/images/icons/notification_friend_icon.png" class="arrowchat_notification_icon" /><a href="#">{author_name}</a> has sent you a friend request.<br /><div class="arrowchat_received">Received {longago}</div></div><div class="arrowchat_notifications_divider"></div>'),
(3, 'Wall Post', 3, '<div class="arrowchat_notification_box arrowchat_blue_link"><img src="/arrowchat/themes/new_facebook_full/images/icons/notification_wall_post.png" class="arrowchat_notification_icon" /><a href="#">{author_name}</a> has wrote on your wall.<br /><div class="arrowchat_received">Received {longago}</div></div><div class="arrowchat_notifications_divider"></div>'),
(4, 'Event Invite', 4, '<div class="arrowchat_notification_box arrowchat_blue_link"><img src="/arrowchat/themes/new_facebook_full/images/icons/notification_event.png" class="arrowchat_notification_icon" /><a href="#">{author_name}</a> has invited you to an event.<br /><div class="arrowchat_received">Received {longago}</div></div><div class="arrowchat_notifications_divider"></div>'),
(5, 'Group Invite', 5, '<div class="arrowchat_notification_box arrowchat_blue_link"><img src="/arrowchat/themes/new_facebook_full/images/icons/notification_group.png" class="arrowchat_notification_icon" /><a href="#">{author_name}</a> has invited you to a group.<br />	<div class="arrowchat_received">Received {longago}</div></div><div class="arrowchat_notifications_divider"></div>'),
(6, 'Birthday', 6, '<div class="arrowchat_notification_box arrowchat_blue_link"><img src="/arrowchat/themes/new_facebook_full/images/icons/notification_birthday.png" class="arrowchat_notification_icon" />It is <a href="#">{author_name}</a>\'s birthday!<br /><div class="arrowchat_received">Received {longago}</div></div><div class="arrowchat_notifications_divider"></div>'),
(7, 'Comment', 7, '<div class="arrowchat_notification_box arrowchat_blue_link"><img src="/arrowchat/themes/new_facebook_full/images/icons/notification_comment.png" class="arrowchat_notification_icon" /><a href="#">{author_name}</a> has left you a comment.<br /><div class="arrowchat_received">Received {longago}</div></div><div class="arrowchat_notifications_divider"></div>'),
(8, 'Reply', 8, '<div class="arrowchat_notification_box arrowchat_blue_link"><img src="/arrowchat/themes/new_facebook_full/images/icons/notification_reply.png" class="arrowchat_notification_icon" /><a href="#">{author_name}</a> has replied to you.<br /><div class="arrowchat_received">Received {longago}</div></div><div class="arrowchat_notifications_divider"></div>'),
(9, 'Like Post', 9, '<div class="arrowchat_notification_box arrowchat_blue_link"><img src="/arrowchat/themes/new_facebook_full/images/icons/notification_like.png" class="arrowchat_notification_icon" /><a href="#">{author_name}</a> has liked your post.<br /><div class="arrowchat_received">Received {longago}</div></div><div class="arrowchat_notifications_divider"></div>'),
(10, 'Like Comment', 10, '<div class="arrowchat_notification_box arrowchat_blue_link"><img src="/arrowchat/themes/new_facebook_full/images/icons/notification_like.png" class="arrowchat_notification_icon" /><a href="#">{author_name}</a> has liked your comment.<br /><div class="arrowchat_received">Received {longago}</div></div><div class="arrowchat_notifications_divider"></div>'),
(11, 'Like Photo', 11, '<div class="arrowchat_notification_box arrowchat_blue_link"><img src="/arrowchat/themes/new_facebook_full/images/icons/notification_like.png" class="arrowchat_notification_icon" /><a href="#">{author_name}</a> has liked your photo.<br /><div class="arrowchat_received">Received {longago}</div></div><div class="arrowchat_notifications_divider"></div>');

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `arrowchat_reports`
--

CREATE TABLE `arrowchat_reports` (
  `id` int(25) UNSIGNED NOT NULL,
  `report_from` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `report_about` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `report_chatroom` int(10) UNSIGNED NOT NULL,
  `report_time` int(20) UNSIGNED NOT NULL,
  `working_by` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `working_time` int(20) UNSIGNED NOT NULL,
  `completed_by` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `completed_time` int(20) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `arrowchat_smilies`
--

CREATE TABLE `arrowchat_smilies` (
  `id` int(3) UNSIGNED NOT NULL,
  `name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Daten für Tabelle `arrowchat_smilies`
--

INSERT INTO `arrowchat_smilies` (`id`, `name`, `code`) VALUES
(1, 'arrowchat_logo.png', '[arrowchat-logo]');

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `arrowchat_status`
--

CREATE TABLE `arrowchat_status` (
  `userid` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guest_name` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `message` text COLLATE utf8mb4_unicode_ci,
  `status` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `theme` int(3) UNSIGNED DEFAULT NULL,
  `popout` int(11) UNSIGNED DEFAULT NULL,
  `typing` text COLLATE utf8mb4_unicode_ci,
  `hide_bar` tinyint(1) UNSIGNED DEFAULT NULL,
  `play_sound` tinyint(1) UNSIGNED DEFAULT '1',
  `window_open` tinyint(1) UNSIGNED DEFAULT NULL,
  `only_names` tinyint(1) UNSIGNED DEFAULT NULL,
  `chatroom_window` varchar(6) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '-1',
  `chatroom_stay` varchar(6) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `chatroom_unfocus` text COLLATE utf8mb4_unicode_ci,
  `chatroom_show_names` tinyint(1) UNSIGNED DEFAULT NULL,
  `chatroom_block_chats` tinyint(1) UNSIGNED DEFAULT NULL,
  `chatroom_sound` tinyint(1) UNSIGNED DEFAULT NULL,
  `announcement` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  `unfocus_chat` text COLLATE utf8mb4_unicode_ci,
  `focus_chat` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_message` text COLLATE utf8mb4_unicode_ci,
  `clear_chats` text COLLATE utf8mb4_unicode_ci,
  `apps_bookmarks` text COLLATE utf8mb4_unicode_ci,
  `apps_other` text COLLATE utf8mb4_unicode_ci,
  `apps_open` int(10) UNSIGNED DEFAULT NULL,
  `apps_load` text COLLATE utf8mb4_unicode_ci,
  `block_chats` text COLLATE utf8mb4_unicode_ci,
  `session_time` int(20) UNSIGNED NOT NULL DEFAULT '0',
  `is_admin` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `is_mod` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `hash_id` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `ip_address` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `arrowchat_themes`
--

CREATE TABLE `arrowchat_themes` (
  `id` int(3) UNSIGNED NOT NULL,
  `folder` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(1) UNSIGNED NOT NULL,
  `update_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `version` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default` tinyint(1) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Daten für Tabelle `arrowchat_themes`
--

INSERT INTO `arrowchat_themes` (`id`, `folder`, `name`, `active`, `update_link`, `version`, `default`) VALUES
(1, 'new_facebook_full', 'New Facebook Full', 1, 'http://www.arrowchat.com/updatecheck.php?id=8', '6.0.1', 1);

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `arrowchat_trayicons`
--

CREATE TABLE `arrowchat_trayicons` (
  `id` int(3) UNSIGNED NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `target` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `width` int(4) UNSIGNED DEFAULT NULL,
  `height` int(4) UNSIGNED DEFAULT NULL,
  `tray_width` int(3) UNSIGNED DEFAULT NULL,
  `tray_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tray_location` int(3) UNSIGNED NOT NULL,
  `active` tinyint(1) UNSIGNED NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `arrowchat_warnings`
--

CREATE TABLE `arrowchat_warnings` (
  `id` int(25) UNSIGNED NOT NULL,
  `user_id` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `warn_reason` text COLLATE utf8mb4_unicode_ci,
  `warned_by` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `warning_time` int(20) UNSIGNED NOT NULL,
  `user_read` tinyint(1) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Indizes der exportierten Tabellen
--

--
-- Indizes für die Tabelle `arrowchat`
--
ALTER TABLE `arrowchat`
  ADD PRIMARY KEY (`id`),
  ADD KEY `to` (`to`),
  ADD KEY `read` (`read`),
  ADD KEY `user_read` (`user_read`),
  ADD KEY `from` (`from`);

--
-- Indizes für die Tabelle `arrowchat_admin`
--
ALTER TABLE `arrowchat_admin`
  ADD PRIMARY KEY (`id`);

--
-- Indizes für die Tabelle `arrowchat_applications`
--
ALTER TABLE `arrowchat_applications`
  ADD PRIMARY KEY (`id`);

--
-- Indizes für die Tabelle `arrowchat_banlist`
--
ALTER TABLE `arrowchat_banlist`
  ADD PRIMARY KEY (`ban_id`);

--
-- Indizes für die Tabelle `arrowchat_chatroom_banlist`
--
ALTER TABLE `arrowchat_chatroom_banlist`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `chatroom_id` (`chatroom_id`);

--
-- Indizes für die Tabelle `arrowchat_chatroom_messages`
--
ALTER TABLE `arrowchat_chatroom_messages`
  ADD PRIMARY KEY (`id`),
  ADD KEY `chatroom_id` (`chatroom_id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `sent` (`sent`);

--
-- Indizes für die Tabelle `arrowchat_chatroom_rooms`
--
ALTER TABLE `arrowchat_chatroom_rooms`
  ADD PRIMARY KEY (`id`),
  ADD KEY `session_time` (`session_time`),
  ADD KEY `author_id` (`author_id`);

--
-- Indizes für die Tabelle `arrowchat_chatroom_users`
--
ALTER TABLE `arrowchat_chatroom_users`
  ADD UNIQUE KEY `user_id` (`user_id`,`chatroom_id`),
  ADD KEY `chatroom_id` (`chatroom_id`),
  ADD KEY `is_admin` (`is_admin`),
  ADD KEY `is_mod` (`is_mod`),
  ADD KEY `session_time` (`session_time`);

--
-- Indizes für die Tabelle `arrowchat_config`
--
ALTER TABLE `arrowchat_config`
  ADD UNIQUE KEY `config_name` (`config_name`);

--
-- Indizes für die Tabelle `arrowchat_graph_log`
--
ALTER TABLE `arrowchat_graph_log`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `date` (`date`);

--
-- Indizes für die Tabelle `arrowchat_notifications`
--
ALTER TABLE `arrowchat_notifications`
  ADD PRIMARY KEY (`id`),
  ADD KEY `to_id` (`to_id`),
  ADD KEY `alert_read` (`alert_read`),
  ADD KEY `user_read` (`user_read`),
  ADD KEY `alert_time` (`alert_time`);

--
-- Indizes für die Tabelle `arrowchat_notifications_markup`
--
ALTER TABLE `arrowchat_notifications_markup`
  ADD PRIMARY KEY (`id`);

--
-- Indizes für die Tabelle `arrowchat_reports`
--
ALTER TABLE `arrowchat_reports`
  ADD PRIMARY KEY (`id`);

--
-- Indizes für die Tabelle `arrowchat_smilies`
--
ALTER TABLE `arrowchat_smilies`
  ADD PRIMARY KEY (`id`);

--
-- Indizes für die Tabelle `arrowchat_status`
--
ALTER TABLE `arrowchat_status`
  ADD PRIMARY KEY (`userid`),
  ADD KEY `hash_id` (`hash_id`),
  ADD KEY `session_time` (`session_time`);

--
-- Indizes für die Tabelle `arrowchat_themes`
--
ALTER TABLE `arrowchat_themes`
  ADD PRIMARY KEY (`id`);

--
-- Indizes für die Tabelle `arrowchat_trayicons`
--
ALTER TABLE `arrowchat_trayicons`
  ADD PRIMARY KEY (`id`);

--
-- Indizes für die Tabelle `arrowchat_warnings`
--
ALTER TABLE `arrowchat_warnings`
  ADD PRIMARY KEY (`id`);

--
-- AUTO_INCREMENT für exportierte Tabellen
--

--
-- AUTO_INCREMENT für Tabelle `arrowchat`
--
ALTER TABLE `arrowchat`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT für Tabelle `arrowchat_admin`
--
ALTER TABLE `arrowchat_admin`
  MODIFY `id` int(3) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;
--
-- AUTO_INCREMENT für Tabelle `arrowchat_applications`
--
ALTER TABLE `arrowchat_applications`
  MODIFY `id` int(3) UNSIGNED NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT für Tabelle `arrowchat_banlist`
--
ALTER TABLE `arrowchat_banlist`
  MODIFY `ban_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT für Tabelle `arrowchat_chatroom_banlist`
--
ALTER TABLE `arrowchat_chatroom_banlist`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT für Tabelle `arrowchat_chatroom_messages`
--
ALTER TABLE `arrowchat_chatroom_messages`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=30;
--
-- AUTO_INCREMENT für Tabelle `arrowchat_chatroom_rooms`
--
ALTER TABLE `arrowchat_chatroom_rooms`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT für Tabelle `arrowchat_graph_log`
--
ALTER TABLE `arrowchat_graph_log`
  MODIFY `id` int(6) UNSIGNED NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT für Tabelle `arrowchat_notifications`
--
ALTER TABLE `arrowchat_notifications`
  MODIFY `id` int(25) UNSIGNED NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT für Tabelle `arrowchat_notifications_markup`
--
ALTER TABLE `arrowchat_notifications_markup`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;
--
-- AUTO_INCREMENT für Tabelle `arrowchat_reports`
--
ALTER TABLE `arrowchat_reports`
  MODIFY `id` int(25) UNSIGNED NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT für Tabelle `arrowchat_smilies`
--
ALTER TABLE `arrowchat_smilies`
  MODIFY `id` int(3) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;
--
-- AUTO_INCREMENT für Tabelle `arrowchat_themes`
--
ALTER TABLE `arrowchat_themes`
  MODIFY `id` int(3) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;
--
-- AUTO_INCREMENT für Tabelle `arrowchat_trayicons`
--
ALTER TABLE `arrowchat_trayicons`
  MODIFY `id` int(3) UNSIGNED NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT für Tabelle `arrowchat_warnings`
--
ALTER TABLE `arrowchat_warnings`
  MODIFY `id` int(25) UNSIGNED NOT NULL AUTO_INCREMENT;
SQL;

        DB::connection()->getPdo()->exec($sql);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        $sql = <<<'SQL'
DROP TABLE `arrowchat`,
`arrowchat_admin`,
`arrowchat_applications`,
`arrowchat_banlist`,
`arrowchat_chatroom_banlist`,
`arrowchat_chatroom_messages`,
`arrowchat_chatroom_rooms`,
`arrowchat_chatroom_users`,
`arrowchat_config`,
`arrowchat_graph_log`,
`arrowchat_notifications`,
`arrowchat_notifications_markup`,
`arrowchat_reports`,
`arrowchat_smilies`,
`arrowchat_status`,
`arrowchat_themes`,
`arrowchat_trayicons`,
`arrowchat_warnings`;
SQL;

        DB::connection()->getPdo()->exec($sql);
    }
}
