<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateLinkInvitationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create( 'link_invitations', function (Blueprint $table) {
            $table->increments('id');

            $table->integer( 'inviting_user_id' )->unsigned();
            $table->foreign( 'inviting_user_id' )->references( 'id' )->on( 'users' );

            $table->integer('coupon_template_id')->nullable()->unsigned();
            $table->foreign( 'coupon_template_id' )->references( 'id' )->on( 'coupon_templates' );

            $table->integer('shared_account_id')->nullable()->unsigned();
            $table->foreign( 'shared_account_id' )->references( 'id' )->on( 'accounts' );

            $table->text('reason');
            $table->text('token');

            $table->timestamps();
        } );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('link_invitations');
    }
}
