<?php

use App\Account;
use App\Branch;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class SellerCreateAccountConnectionsFromAccountBranch extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $role = Spatie\Permission\Models\Role::where('name', '=', 'seller')->count();
        if($role == 1) {
            $sellerAccounts = \App\Account::allSellerAccounts();
            foreach ($sellerAccounts as $sellerAccount) {
                $branches = [];
                $branch = \App\Branch::where('name', '=', $sellerAccount->branch)->first();
                if (isset($branch)) {
                    array_push($branches, $branch->id);
                    $sellerAccount->branches()->sync($branches, false);

                    $sellerAccount->branch = '';
                    $sellerAccount->save();
                }
                //else branch name was changed and does not exist anymore
            }
        }

        Schema::table('accounts', function ($table) {
            $table->dropColumn('branch');
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
