<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAccountHasBranches extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create( 'account_has_branches', function (Blueprint $table) {
            $table->integer( 'account_id' )->unsigned();
            $table->foreign( 'account_id' )->references( 'id' )->on( 'accounts' );

            $table->integer( 'branch_id' )->unsigned();
            $table->foreign( 'branch_id' )->references( 'id' )->on( 'branches' );

        } );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('account_has_branches');
    }
}
