<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddSellerEmailVerificationToUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function($table){
            $table->string('email_verification_token')->nullable();
            $table->boolean('email_verified')->default(false);
        });

        // mark all current users verified
	    DB::table('users')->update(array('email_verified' => 1));
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function($table){
            $table->dropColumn('email_verification_token');
            $table->dropColumn('email_verified');
        });
    }
}
