<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddStatusTimestampsToCoupons extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('coupons', function ($table) {
            $table->timestamp('status_pending_at')->nullable();
            $table->timestamp('status_active_at')->nullable();
            $table->timestamp('status_redeemed_at')->nullable();
            $table->timestamp('status_paid_at')->nullable();
            $table->timestamp('status_done_at')->nullable();
            $table->timestamp('status_payment_requested_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('coupons', function ($table) {
            $table->dropColumn('status_pending_at');
            $table->dropColumn('status_active_at');
            $table->dropColumn('status_redeemed_at');
            $table->dropColumn('status_paid_at');
            $table->dropColumn('status_done_at');
            $table->dropColumn('status_payment_requested_at');
        });
    }
}
