<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddStatusTimestampsToTransactions extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('transactions', function ($table) {
            $table->timestamp('status_pending_at')->nullable();
            $table->timestamp('status_allocated_at')->nullable();
            $table->timestamp('status_paid_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('transactions', function ($table) {
            $table->dropColumn('status_pending_at');
            $table->dropColumn('status_allocated_at');
            $table->dropColumn('status_paid_at');
        });
    }
}
