<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddBankTransactionToInovicesAndCreditNotesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('bank_transactions', function (Blueprint $table) {
            $table->bigInteger('id')->unsigned()->change();
            $table->primary('id');
        });
        Schema::table('invoices', function ($table) {
            $table->bigInteger('bank_transaction_id')->unsigned()->nullable()->default(NULL);
            $table->foreign('bank_transaction_id')->references('id')->on('bank_transactions');
        });
        Schema::table('credit_notes', function ($table) {
            $table->bigInteger('bank_transaction_id')->unsigned()->nullable()->default(NULL);
            $table->foreign('bank_transaction_id')->references('id')->on('bank_transactions');
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('invoices', function ($table) {
            $table->dropForeign('invoices_bank_transaction_id_foreign');
            $table->dropColumn('bank_transaction_id');
        });

        Schema::table('credit_notes', function ($table) {
            $table->dropForeign('credit_notes_bank_transaction_id_foreign');
            $table->dropColumn('bank_transaction_id');
        });
    }
}
