<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddDataToInvoicesAndCreditNotesTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('invoices', function ($table) {
            $table->integer('user_id');
            $table->decimal('gross_amount');
            $table->string('number');
        });
        Schema::table('credit_notes', function ($table) {
            $table->integer('user_id');
            $table->decimal('gross_amount');
            $table->string('number');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('invoices', function ($table) {
            $table->dropColumn('user_id');
            $table->dropColumn('gross_amount');
            $table->dropColumn('number');
        });
        Schema::table('credit_notes', function ($table) {
            $table->dropColumn('user_id');
            $table->dropColumn('gross_amount');
            $table->dropColumn('number');
        });
    }
}
