<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ReplaceBillomatWithReceiptReferenceInTransactionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('transactions', function ($table) {
            $table->integer('invoice_id')->unsigned()->nullable()->default(NULL);
            $table->foreign('invoice_id')->references('id')->on('invoices');

            $table->integer('credit_note_id')->unsigned()->nullable()->default(NULL);
            $table->foreign('credit_note_id')->references('id')->on('credit_notes');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('transactions', function ($table) {
            $table->dropForeign('transactions_invoice_id_foreign');
            $table->dropForeign('transactions_credit_note_id_foreign');

            $table->dropColumn('invoice_id');
            $table->dropColumn('credit_note_id');
        });
    }
}
