<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBankTransactionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bank_transactions', function (Blueprint $table) {
            $table->bigInteger('id');
            $table->timestamps();
            $table->dateTime('date');
            $table->dateTime('valuta_date');
            $table->decimal('amount');
            $table->string('currency', 3);
            $table->string('purpose');
            $table->string('remote_bank_code');
            $table->string('remote_account_number');
            $table->string('remote_account_holder_name');
            $table->string('local_bank_code');
            $table->string('local_account_number');
            $table->string('local_account_holder_name');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('bank_transactions');
    }
}
