<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddAllConnectionsToAccounts extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::table( 'accounts', function($table) {
            $table->boolean("all_connections")->comment('Allow all connections (seller allows all agents)');
        } );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::table( 'accounts', function($table) {
            $table->dropColumn("all_connections");
        } );
    }
}
