<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSubscriptionRecurringTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create( 'subscription_recurrings', function (Blueprint $table) {
            $table->increments( 'id' );

            $table->integer( 'billomat_id' )->unsigned()->nullable();
            
            $table->integer( 'user_id' )->unsigned();
            $table->foreign( 'user_id' )->references( 'id' )->on( 'users' );
            
            $table->timestamps();
        } );
        
        Schema::create( 'invoice_subscription_recurring', function (Blueprint $table) {

            $table->integer( 'subscription_recurring_id' )->unsigned();
            $table->foreign( 'subscription_recurring_id' )->references( 'id' )->on( 'subscription_recurrings' );

            $table->integer( 'invoice_id' )->unsigned();
            $table->foreign( 'invoice_id' )->references( 'id' )->on( 'invoices' );

            $table->timestamps();
        } );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('invoice_subscription_recurring');
        Schema::drop('subscription_recurrings');
    }
}
