<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCreditNoteTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create( 'credit_notes', function (Blueprint $table) {
            $table->increments( 'id' );

            $table->integer( 'transaction_id' )->unsigned();
            $table->foreign( 'transaction_id' )->references( 'id' )->on( 'transactions' );
            
            $table->integer( 'billomat_id' )->unsigned()->nullable();
            
            $table->string( 'pdf_path' )->nullable();

            $table->timestamps();
        } );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::drop('credit_notes');
    }
}
