<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBillomatInvoiceTable extends Migration {

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        
        Schema::create( 'invoices', function (Blueprint $table) {
            $table->increments( 'id' );

            $table->integer( 'coupon_id' )->unsigned()->nullable();
            $table->foreign( 'coupon_id' )->references( 'id' )->on( 'coupons' );

            $table->integer( 'billomat_id' )->unsigned()->nullable();
            
            $table->string( 'pdf_path' )->nullable();
            
            $table->string( 'status' );
            $table->string( 'type' );

            $table->timestamps();
        } );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::drop('invoices');
    }

}
