<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAccountConnectionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('account_connections', function (Blueprint $table) {
            $table->increments('id');

            $table->integer('account_id')->unsigned();
            $table->foreign('account_id')->references('id')->on('accounts')->onDelete('cascade');
            $table->integer('related_account_id')->unsigned();
            $table->foreign('related_account_id')->references('id')->on('accounts')->onDelete('cascade');

            $table->string('type');
            $table->string('status');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('account_connections', function($table)
        {
            $table->dropForeign('account_connections_account_id_foreign');
            $table->dropForeign('account_connections_related_account_id_foreign');
        });

        Schema::drop('account_connections');
    }
}
