<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInvitationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invitations', function (Blueprint $table) {
            $table->increments('id');

            $table->integer('account_id')->unsigned(); // ID von einladendem User
            $table->foreign('account_id')->references('id')->on('accounts')->onDelete('cascade');

            $table->string('required_role')->nullable();

            $table->integer('invited_account_id')->unsigned(); // ID von eingeladenem User
            $table->foreign('invited_account_id')->references('id')->on('accounts')->onDelete('cascade');

            $table->string('status'); // pending, accepted, rejected

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('invitations', function($table)
        {
            $table->dropForeign('invitations_account_id_foreign');
            $table->dropForeign('invitations_invited_account_id_foreign');
        });

        Schema::drop('invitations');
    }
}
