<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAccountsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('accounts', function (Blueprint $table) {
            $table->increments('id');

            $table->string('iban')->nullable();
            $table->string('iban_owner')->nullable();

            $table->string('company')->nullable();
            $table->string('street')->nullable();
            $table->string('housenumber')->nullable();
            $table->integer('zip')->nullable();
            $table->string('city')->nullable();

            $table->string('tax_id')->nullable();
            $table->string('branch')->nullable();

            $table->string('payment')->nullable();

            $table->string('status');

            $table->string('upload_portrait')->nullable();

            $table->text('description')->nullable();

            $table->timestamps();
        });

        Schema::table('users', function($table) {
            $table->integer('account_id')->unsigned();
            $table->foreign('account_id')->references('id')->on('accounts')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function($table)
        {
            $table->dropForeign('users_account_id_foreign');
        });

        Schema::drop('accounts');
    }
}
