<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTransactionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->increments('id');

            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users');

            $table->integer('coupon_id')->unsigned()->nullable;
            $table->foreign('coupon_id')->references('id')->on('coupons');

            $table->decimal('amount');
            $table->string('type'); // operator-coupon-provision-credit, agent-coupon-provision-credit, consumer-coupon-discount-credit, seller-fee-yearly-payment, seller-fee-monthly-payment, seller-operator-provision-payment, seller-agent-provision-payment, seller-consumer-discount-payment

            $table->string('status'); // pending, rate, allocated, paid

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('transactions', function($table)
        {
            $table->dropForeign('transactions_user_id_foreign');
            $table->dropForeign('transactions_coupon_id_foreign');
        });

        Schema::drop('transactions');
    }
}
