<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCouponTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('coupons', function (Blueprint $table) {
            $table->increments('id');

            $table->integer('coupon_template_id')->unsigned();
            $table->foreign('coupon_template_id')->references('id')->on('coupon_templates');

            $table->integer('consumer_user_id')->unsigned();
            $table->foreign('consumer_user_id')->references('id')->on('users');
            $table->integer('agent_user_id')->unsigned();
            $table->foreign('agent_user_id')->references('id')->on('users');

            $table->string('title');
            $table->date('expiration_date');
            $table->text('description');
            $table->integer('provision_agent');
            $table->integer('discount_consumer');

            $table->string('status');
            $table->string('code');

            $table->float('brutto');
            $table->decimal('netto', 25, 2);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('coupons');
    }
}
