<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class CreatePermissionTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $config = config('laravel-permission.table_names');

        Schema::create($config['roles'], function (Blueprint $table) {
            $table->increments('id');
            $table->string('name')->unique();
            $table->timestamps();
        });

        Schema::create($config['permissions'], function (Blueprint $table) {
            $table->increments('id');
            $table->string('name')->unique();
            $table->timestamps();
        });

        Schema::create($config['user_has_permissions'], function (Blueprint $table) use ($config) {
            $table->integer('user_id')->unsigned();
            $table->integer('permission_id')->unsigned();

            $table->foreign('user_id')
                ->references('id')
                ->on($config['users'])
                ->onDelete('cascade');

            $table->foreign('permission_id')
                ->references('id')
                ->on($config['permissions'])
                ->onDelete('cascade');

            $table->primary(['user_id', 'permission_id']);
        });

        Schema::create($config['user_has_roles'], function (Blueprint $table) use ($config) {
            $table->integer('role_id')->unsigned();
            $table->integer('user_id')->unsigned();

            $table->foreign('role_id')
                ->references('id')
                ->on($config['roles'])
                ->onDelete('cascade');

            $table->foreign('user_id')
                ->references('id')
                ->on($config['users'])
                ->onDelete('cascade');

            $table->primary(['role_id', 'user_id']);

            Schema::create($config['role_has_permissions'], function (Blueprint $table) use ($config) {
                $table->integer('permission_id')->unsigned();
                $table->integer('role_id')->unsigned();

                $table->foreign('permission_id')
                    ->references('id')
                    ->on($config['permissions'])
                    ->onDelete('cascade');

                $table->foreign('role_id')
                    ->references('id')
                    ->on($config['roles'])
                    ->onDelete('cascade');

                $table->primary(['permission_id', 'role_id']);
            });
        });


        //show permissions - Navigation
        Permission::create(['name' => 'show user profile']);
        Permission::create(['name' => 'show consumer transactions']);
        Permission::create(['name' => 'show consumer coupon']);
        Permission::create(['name' => 'show consumer dashboard']);
        Permission::create(['name' => 'show agent dashboard']);
        Permission::create(['name' => 'show operator dashboard']);
        Permission::create(['name' => 'show seller dashboard']);
        Permission::create(['name' => 'show agent coupons']);
        Permission::create(['name' => 'show agent transactions']);
        Permission::create(['name' => 'show coupon management']);
        Permission::create(['name' => 'redeem coupon']);
        Permission::create(['name' => 'create coupon template']);
        Permission::create(['name' => 'show users']);
        Permission::create(['name' => 'show agents']);
        Permission::create(['name' => 'show consumer']);
        Permission::create(['name' => 'show seller transactions']);
        Permission::create(['name' => 'show operator transactions']);
        Permission::create(['name' => 'edit users']);
        Permission::create(['name' => 'create users']);
        Permission::create(['name' => 'delete users']);
        Permission::create(['name' => 'invite agents']);
        Permission::create(['name' => 'show job-queue']);
        Permission::create(['name' => 'show seller']);
        Permission::create(['name' => 'filter dashboard']);
        Permission::create(['name' => 'show account']);
        Permission::create(['name' => 'show invitation']);
        Permission::create(['name' => 'show own rating']);
        Permission::create(['name' => 'export sepa files']);
        Permission::create(['name' => 'recommend-recoma']);
        Permission::create(['name' => 'edit account']);
        Permission::create(['name' => 'edit account data']);

        //roles
        //Betreiber
        $role = Role::create(['name' => 'operator']);
        $role->givePermissionTo('show users');
        $role->givePermissionTo('show operator dashboard');
        $role->givePermissionTo('show user profile');
        $role->givePermissionTo('show operator transactions');
        $role->givePermissionTo('edit users');
        $role->givePermissionTo('create users');
        $role->givePermissionTo('delete users');
//        $role->givePermissionTo('show job-queue'); //development only
        $role->givePermissionTo('filter dashboard');
        $role->givePermissionTo('show account');
        $role->givePermissionTo('show invitation');
        $role->givePermissionTo('export sepa files');


        //Dienstleister
        $role = Role::create(['name' => 'seller']);
        $role->givePermissionTo('show seller dashboard');
        $role->givePermissionTo('filter dashboard');
        $role->givePermissionTo('show user profile');
        $role->givePermissionTo('show coupon management');
        $role->givePermissionTo('create coupon template');

        $role = Role::create(['name' => 'seller-active']);
        $role->givePermissionTo('redeem coupon');
        $role->givePermissionTo('show own rating');
        $role->givePermissionTo('show invitation');
        $role->givePermissionTo('invite agents');
        $role->givePermissionTo('show seller transactions');
        $role->givePermissionTo('show agents');

        //Empfehler / Agent
        $role = Role::create(['name' => 'agent']);
        $role->givePermissionTo('show agent dashboard');
        $role->givePermissionTo('show consumer');
        $role->givePermissionTo('show user profile');
        $role->givePermissionTo('show agent coupons');
        $role->givePermissionTo('show agent transactions');
        $role->givePermissionTo('show seller');
        $role->givePermissionTo('filter dashboard');
        $role->givePermissionTo('show invitation');

        //Interessent / Consumer
        $role = Role::create(['name' => 'consumer']);
        $role->givePermissionTo('show consumer dashboard');
        $role->givePermissionTo('show consumer coupon');
        $role->givePermissionTo('show user profile');
        $role->givePermissionTo('show consumer transactions');
        $role->givePermissionTo('filter dashboard');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        $config = config('laravel-permission.table_names');

        Schema::drop($config['role_has_permissions']);
        Schema::drop($config['user_has_roles']);
        Schema::drop($config['user_has_permissions']);
        Schema::drop($config['roles']);
        Schema::drop($config['permissions']);
    }
}
