<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->increments('id');

            $table->string('salutation');
            $table->string('firstname');
            $table->string('surname');

            $table->string('email')->unique();
            $table->string('mobile');
            $table->boolean('mobile_verified');
            $table->string('mobile_verification_token')->unique()->nullable();
            $table->string('phone');
            $table->string('fax');

            $table->string('status');
            $table->string('password');
            $table->string('upload_portrait');

            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('users');
    }
}
