<?php

return [
    
    /*
    |--------------------------------------------------------------------------
    | API Related Configuration
    |--------------------------------------------------------------------------
    |
    | All directly http://www.billomat.com/api/ related configurations
    |
    */
    
    'api' => [
        //No default - Credential required
        'id'    => env('BILLOMAT_API_ID',false),
        'key'   => env('BILLOMAT_API_KEY',false),
        
        'app' => [
            //If false, no app used, use non-app access
            'id'        => env('BILLOMAT_API_APP_ID',false),
            'secret'    => env('BILLOMAT_API_APP_SECRET',false),
        ],
    ],

    'articles' => [
	    \App\Transaction::TYPE_SELLER_AGENT_PROVISION_PAYMENT => 'RECOCASH_IN1',
	    \App\Transaction::TYPE_SELLER_CONSUMER_DISCOUNT_PAYMENT => 'CASHBACK_IN1',
	    \App\Transaction::TYPE_SELLER_OPERATOR_PROVISION_PAYMENT=> 'FEE_TRANSACTION1',
	    \App\Transaction::TYPE_CONSUMER_COUPON_DISCOUNT_CREDIT=> 'CASHBACK_OUT1',
	    \App\Transaction::TYPE_AGENT_COUPON_PROVISION_CREDIT=> 'RECOCASH_OUT1',
	    \App\Transaction::TYPE_SELLER_FEE_MONTHLY_PAYMENT=> 'FEE_MONTHLY1',
	    \App\Transaction::TYPE_SELLER_FEE_YEARLY_PAYMENT=> 'FEE_YEARLY1',
	    \App\Transaction::TYPE_AGENT_RECOMMENDATION_PROVISION_CREDIT=> 'RECOCASH_OUT1',
    ],

    /*
    |--------------------------------------------------------------------------
    | PDF Related Configuration
    |--------------------------------------------------------------------------
    |
    */

    'pdf' => [
        'pathes' => [
            'base' =>  env('invoices/pdf/'),
        ],
        
        'storage' => 'public',
        
        'type' => [
            'subscription' => [
                'templateid' => env('BILLOMAT_INTERFACE_TYPE_SUBSCRIPTION_TEMPLATE_ID', 0),
                'title' => env('BILLOMAT_INTERFACE_TYPE_SUBSCRIPTION_TITLE', 'Mitgliedsbeitrag'),
                //TODO edit default value or set to no default
                'name' => env('BILLOMAT_INTERFACE_TYPE_SUBSCRIPTION_NAME', 'Recoma Abo'),
                'label' => env('BILLOMAT_INTERFACE_TYPE_SUBSCRIPTION_NAME_LABEL', 'Beitragsrechnung'),
                
                'cycle' => env('BILLOMAT_INTERFACE_TYPE_SUBSCRIPTION_NAME_CYCLE', 'MONTHLY'),
                'cycle_number' => env('BILLOMAT_INTERFACE_TYPE_SUBSCRIPTION_NAME_CYCLE_NUM', 1),
                
                'action' => 'EMAIL',
                
                'abo_length_month' => 12,
                
                'item' => [
                    'title' => 'Mitgliedsbeitrag monatlich',
                    'description' => 'Monatlicher Abo-Betrag für die Nutzung des Systems',
                ],
                
            ],
            'invoice' => [
                'templateid' => env('BILLOMAT_INTERFACE_TYPE_INVOICE_TEMPLATE_ID', 45135),
            ],
            'credit_note' => [
                'templateid' => env('BILLOMAT_INTERFACE_TYPE_CREDIT_NOTE_TEMPLATE_ID', 42495),
            ],
            'recurring' => [
                'templateid' => env('BILLOMAT_INTERFACE_TYPE_RECURRING_TEMPLATE_ID', 45135),
            ]
        ],
    ],
    
    
    
    
];
